/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ascontroller;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.asconfiguration.ascontroller.ServerManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.impl.CommandContextConfiguration;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.security.vault.VaultSession;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServerCommands {
    private static final String RUN_BATCH_CMD = "run-batch";
    private static final String RELOAD_CMD = "reload --admin-only=true";
    private static final String DOMAIN_CMD_PREFIX = "/host=%s";
    private static final String SHUTDOWN_CMD = ":shutdown";
    private static VaultSession vault = null;
    private String keystore;
    private String alias;
    private String encrDir;
    private String salt;
    private int iterations;
    private CommandContext context;
    private boolean isDomain;
    private String[] domainProfiles;
    private static String domainHostname = "master";
    private final String[] validAuthenticationCodes = new String[]{"Client", "org.jboss.security.ClientLoginModule", "Certificate", "org.jboss.security.auth.spi.BaseCertLoginModule", "CertificateUsers", "org.jboss.security.auth.spi.BaseCertLoginModule", "CertificateRoles", "org.jboss.security.auth.spi.CertRolesLoginModule", "Database", "org.jboss.security.auth.spi.DatabaseServerLoginModule", "DatabaseCertificate", "org.jboss.security.auth.spi.DatabaseCertLoginModule", "DatabaseUsers", "org.jboss.security.auth.spi.DatabaseServerLoginModule", "Identity", "org.jboss.security.auth.spi.IdentityLoginModule", "Ldap", "org.jboss.security.auth.spi.LdapLoginModule", "LdapExtended", "org.jboss.security.auth.spi.LdapExtLoginModule", "RoleMapping", "org.jboss.security.auth.spi.RoleMappingLoginModule", "RunAs", "org.jboss.security.auth.spi.RunAsLoginModule", "Simple", "org.jboss.security.auth.spi.SimpleServerLoginModule", "ConfiguredIdentity", "org.picketbox.datasource.security.ConfiguredIdentityLoginModule", "SecureIdentity", "org.picketbox.datasource.security.SecureIdentityLoginModule", "PropertiesUsers", "org.jboss.security.auth.spi.PropertiesUsersLoginModule", "SimpleUsers", "org.jboss.security.auth.spi.SimpleUsersLoginModule", "LdapUsers", "org.jboss.security.auth.spi.LdapUsersLoginModule", "Kerberos", "com.sun.security.auth.module.K5b5LoginModule", "SPNEGOUsers", "org.jboss.security.negotiation.spnego.SPNEGOLoginModule", "AdvancedLdap", "org.jboss.security.negotiation.AdvancedLdapLoginModule", "AdvancedADLdap", "org.jboss.security.negotiation.AdvancedADLoginModule", "UsersRoles", "org.jboss.security.auth.spi.UsersRolesLoginModule"};
    private final String[] validAuthorizationCodes = new String[]{"DenyAll", "org.jboss.security.authorization.modules.AllDenyAuthorizationModule", "PermitAll", "org.jboss.security.authorization.modules.AllPermitAuthorizationModule", "Delegating", "org.jboss.security.authorization.modules.DelegatingAuthorizationModule", "Web", "org.jboss.security.authorization.modules.WebAuthorizationModule", "JACC", "org.jboss.security.authorization.modules.JACCAuthorizationModule", "XACML", "org.jboss.security.authorization.modules.XACMLAuthorizationModule"};
    private final String[] validMappingCodes = new String[]{"PropertiesRoles", "org.jboss.security.mapping.providers.role.PropertiesRolesMappingProvider", "SimpleRoles", "org.jboss.security.mapping.providers.role.SimpleRolesMappingProvider", "DeploymentRoles", "org.jboss.security.mapping.providers.DeploymentRolesMappingProvider", "DatabaseRoles", "org.jboss.security.mapping.providers.role.DatabaseRolesMappingProvider", "LdapRoles", "org.jboss.security.mapping.providers.role.LdapRolesMappingProvider"};
    private final String[] validFlags = new String[]{"Required", "Requisite", "Sufficient", "Optional"};
    private final String[] validTypes = new String[]{"principal", "credential", "role", "attribute"};
    private String logFilePath = null;
    private List<String> naiveLogger;
    private Logger logger;

    private ServerCommands() {
        this.naiveLogger = new ArrayList<String>(1);
    }

    private ServerCommands(String user, char[] pwd, String host, int port, boolean slave, String ... profile) throws CliInitializationException {
        if (profile != null) {
            this.domainProfiles = profile;
            this.isDomain = true;
        }
        HashMap<String, String> newEnv = new HashMap<String, String>();
        newEnv.put("JBOSS_HOME", AutomatedInstallData.getInstance().getInstallPath() + File.separator);
        ServerCommands.addEnv(newEnv);
        CommandContextConfiguration ccConfig = new CommandContextConfiguration.Builder().setController(host + ":" + port).setUsername(user).setPassword(pwd).build();
        this.context = CommandContextFactory.getInstance().newCommandContext(ccConfig);
        this.context.setSilent(true);
        this.context.setResolveParameterValues(false);
        this.naiveLogger = new ArrayList<String>(1);
    }

    public static ServerCommands createEmbeddedSession() {
        return new ServerCommands();
    }

    public static ServerCommands createLocalDomainUsernameSession(String user, char[] pwd, int port, boolean slave, String ... profile) throws CliInitializationException {
        return new ServerCommands(user, pwd, "localhost", port, slave, profile);
    }

    public static ServerCommands createLocalStandaloneUsernameSession(String user, char[] pwd, int port) throws CliInitializationException {
        return new ServerCommands(user, pwd, "localhost", port, false, null);
    }

    public static ServerCommands createRemoteUsernameSession(String user, char[] pwd, int port, String profile, String host) throws CliInitializationException {
        return new ServerCommands(user, pwd, host, port, false, profile);
    }

    public static ServerCommands createSession(String user, char[] pwd, int port) throws CliInitializationException {
        return new ServerCommands(user, pwd, null, port, false, null);
    }

    public void createNewBatch() {
        this.context.getBatchManager().activateNewBatch();
    }

    public void storeCurrentBatch(String name) {
        this.context.getBatchManager().holdbackActiveBatch(name);
    }

    public String[] getDomainProfiles() {
        return this.domainProfiles;
    }

    public void setDomainProfiles(String ... domainProfile) {
        this.domainProfiles = domainProfile;
    }

    public void setResolveParameterValues(boolean resolve) {
        this.context.setResolveParameterValues(resolve);
    }

    boolean hasVault() {
        return vault != null;
    }

    public void setLogFilePath(String loc) {
        this.logFilePath = loc;
    }

    public void closeLogHandlers() {
        this.logger.info("Finished commands from: " + this.logger.getName());
        for (Handler h : this.logger.getHandlers()) {
            h.close();
            this.logger.removeHandler(h);
        }
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void terminateSession() {
        this.closeLogHandlers();
        if (!this.context.isTerminated()) {
            this.context.terminateSession();
        }
    }

    public void connectContext() throws CommandLineException {
        if (this.context.getControllerHost() == null && this.context.isBatchMode()) {
            this.context.connectController();
            for (String command : this.naiveLogger) {
                try {
                    this.handle(command);
                }
                catch (CommandLineException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.context.connectController();
        }
    }

    public void connectContext(String host, int port) throws CommandLineException {
        this.context.connectController(host, port);
    }

    public void createVaultSession(String keystore, String keystorePwd, String encrDir, String salt, int iterations, String alias) throws Throwable {
        this.keystore = keystore;
        this.encrDir = encrDir;
        this.salt = salt;
        this.iterations = iterations;
        this.alias = alias;
        if (!encrDir.endsWith(File.separator)) {
            encrDir = encrDir + File.separator;
        }
        if (!this.hasVault()) {
            vault = new VaultSession(keystore, keystorePwd, encrDir, salt, iterations);
            vault.startVaultSession(alias);
        }
    }

    public List<ModelNode> installVault() {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (!this.hasVault()) {
            result.add(this.getFailureResult("ServerCommands.installVault()", "ServerCommands : No vault has been initialized. No Vault installation attempted."));
            return result;
        }
        String masked = vault.getKeystoreMaskedPassword();
        String addVaultCmd = "/core-service=vault:add(vault-options=[(\"KEYSTORE_URL\" => \"" + this.keystore.replaceAll("\\\\", "/") + "\"), (\"KEYSTORE_PASSWORD\" => \"" + masked + "\"), (\"KEYSTORE_ALIAS\" => \"" + this.alias + "\"), (\"SALT\" => \"" + this.salt + "\"), (\"ITERATION_COUNT\" => \"" + this.iterations + "\"), (\"ENC_FILE_DIR\" => \"" + this.encrDir.replaceAll("\\\\", "/") + "\")])";
        result.add(this.submitCommand(addVaultCmd));
        return result;
    }

    public List<ModelNode> installVault(String keystore, String encrDir) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (!this.hasVault()) {
            result.add(this.getFailureResult("ServerCommands.installVault()", "ServerCommands : No vault has been initialized. No Vault installation attempted."));
            return result;
        }
        String masked = vault.getKeystoreMaskedPassword();
        String addVaultCmd = "/core-service=vault:add(vault-options=[(\"KEYSTORE_URL\" => \"" + keystore.replaceAll("\\\\", "/") + "\"), (\"KEYSTORE_PASSWORD\" => \"" + masked + "\"), (\"KEYSTORE_ALIAS\" => \"" + this.alias + "\"), (\"SALT\" => \"" + this.salt + "\"), (\"ITERATION_COUNT\" => \"" + this.iterations + "\"), (\"ENC_FILE_DIR\" => \"" + encrDir.replaceAll("\\\\", "/") + "\")])";
        result.add(this.submitCommand(addVaultCmd));
        return result;
    }

    public List<ModelNode> addSystemProperty(String propertyName, String propertyValue) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        String checkPropertyCmd = "/system-property=" + propertyName + ":read-attribute(name=value)";
        boolean existsAlready = Operations.isSuccessfulOutcome(this.submitCommand(checkPropertyCmd));
        String addPropertyCmd = "/system-property=" + propertyName + ":add(value=" + propertyValue + ")";
        if (!existsAlready) {
            result.add(this.submitCommand(addPropertyCmd));
        }
        return result;
    }

    public List<ModelNode> addPropertyToIndividualServer(String serverConfig, String propertyName, String propertyValue, boolean bootTime) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (this.isDomain) {
            ModelNode check = this.getServerConfigList();
            for (ModelNode c : check.get("result").asList()) {
                if (!c.asString().equals(serverConfig)) continue;
                String addPropertyCommand = "/host=master/server-config=" + serverConfig + "/system-property=" + propertyName + ":add(value=" + propertyValue + ",boot-time=" + bootTime;
                result.add(this.addToLoggerAndHandle(addPropertyCommand));
            }
        }
        return result;
    }

    public List<ModelNode> setServerAutoStart(String serverConfig, boolean autoStart) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (this.isDomain) {
            ModelNode configCheck = this.getServerConfigList();
            for (ModelNode c : configCheck.get("result").asList()) {
                if (!c.asString().equals(serverConfig)) continue;
                String autoStartCommand = "/host=master/server-config=" + serverConfig + ":" + this.writeAttribute("auto-start", String.valueOf(autoStart));
                result.add(this.addToLoggerAndHandle(autoStartCommand));
            }
        }
        return result;
    }

    private ModelNode getServerConfigList() {
        String command = "/host=master:read-children-names(child-type=server-config)";
        return this.addToLoggerAndHandle(command);
    }

    public List<ModelNode> deployArtifact(String artifactPath) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        String command = this.isDomain ? "deploy " + artifactPath + " --all-server-groups" : "deploy " + artifactPath;
        result.add(this.addToLoggerAndHandle(command));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createModuleXml(String basePath, String modulePath, String moduleName, List<String> resourceNames, List<String> dependencyNames) throws ParserConfigurationException, TransformerException, IOException {
        File module = new File(basePath, modulePath + File.separator + "module.xml");
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("module");
        Attr xmlns = doc.createAttribute("xmlns");
        Attr modName = doc.createAttribute("name");
        xmlns.setValue("urn:jboss:module:1.0");
        modName.setValue(moduleName);
        root.setAttributeNode(xmlns);
        root.setAttributeNode(modName);
        doc.appendChild(root);
        Element resources = doc.createElement("resources");
        root.appendChild(resources);
        for (String string : resourceNames) {
            Element resourceRoot = doc.createElement("resource-root");
            Attr resourcePath = doc.createAttribute("path");
            resourcePath.setValue(string);
            resourceRoot.setAttributeNode(resourcePath);
            resources.appendChild(resourceRoot);
        }
        Element dependencies = doc.createElement("dependencies");
        root.appendChild(dependencies);
        for (String dep : dependencyNames) {
            Element dependency = doc.createElement("module");
            Attr depName = doc.createAttribute("name");
            depName.setValue(dep);
            dependency.setAttributeNode(depName);
            dependencies.appendChild(dependency);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer trans = transformerFactory.newTransformer();
        trans.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new StringWriter());
        trans.transform(source, result);
        String outputString = result.getWriter().toString();
        try (BufferedWriter writeOut = null;){
            writeOut = new BufferedWriter(new FileWriter(module));
            writeOut.write(outputString);
        }
    }

    String maskPassword(String vaultBlock, String vaultAttribute, String password) {
        String ret = "";
        if (vault != null) {
            try {
                ret = "${" + vault.addSecuredAttribute(vaultBlock, vaultAttribute, password.toCharArray()) + "}";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String maskPasswordPlain(String vaultBlock, String vaultAttribute, String password) {
        String ret = "";
        if (vault != null) {
            try {
                ret = vault.addSecuredAttribute(vaultBlock, vaultAttribute, password.toCharArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List<ModelNode> installSslCustom(String keystore, String keystorePwd, String realmName, String vaultBlock, String attributeName) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        String password = keystorePwd;
        if (this.hasVault()) {
            password = this.maskPassword(vaultBlock, attributeName, password);
        }
        String addSslCmd = "/core-service=management/security-realm=" + realmName + "/server-identity=ssl:add(keystore-path=\"" + keystore.replaceAll("\\\\", "/") + "\",keystore-password=\"" + password + "\")";
        result.add(this.submitCommand(addSslCmd));
        String addTrustStoreCmd = "/core-service=management/security-realm=" + realmName + "/authentication=truststore:add(keystore-path=\"" + keystore.replaceAll("\\\\", "/") + "\",keystore-password=\"" + password + "\"";
        result.add(this.submitCommand(addTrustStoreCmd));
        return result;
    }

    public List<ModelNode> installSsl(String keystore, String keystorePwd, String realmName) {
        return this.installSslCustom(keystore, keystorePwd, realmName, "ssl", "password");
    }

    public List<ModelNode> addHttps(String realm) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (this.isDomain) {
            result.addAll(this.setUpDomain(realm));
        } else {
            result.addAll(this.setUpStandalone(realm));
        }
        return result;
    }

    public List<ModelNode> setUpDomain(String realm) {
        ArrayList<ModelNode> results = new ArrayList<ModelNode>();
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        if (ServerManager.SLAVE) {
            String addCommand = "/core-service=management/management-interface=http-interface:add(interface=management,security-realm=\"" + realm + "\")";
            results.add(this.submitCommand(addCommand));
        }
        String addSecurePort = String.format("/core-service=management/management-interface=http-interface:write-attribute(name=secure-port, value=\"%s\"", idata.getVariable("domain.management-https"));
        String undefineNonSecurePort = "/core-service=management/management-interface=http-interface:undefine-attribute(name=port)";
        String readResources = "/core-service=management/management-interface=http-interface:read-resource";
        results.add(this.submitCommand(addSecurePort));
        results.add(this.submitCommand(undefineNonSecurePort));
        results.add(this.submitCommand(readResources));
        return results;
    }

    public List<ModelNode> setUpStandalone(String realm) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        String redefineService = "/core-service=management/management-interface=http-interface:undefine-attribute(name=security-realm)";
        String addCommand = "/core-service=management/management-interface=http-interface:write-attribute(name=security-realm,value=\"" + realm + "\")";
        result.add(this.submitCommand(redefineService));
        result.add(this.submitCommand(addCommand));
        String undefineHttp = "/core-service=management/management-interface=http-interface:undefine-attribute(name=socket-binding";
        String defineHttps = "/core-service=management/management-interface=http-interface:write-attribute(name=secure-socket-binding,value=management-https)";
        ModelNode check = this.submitCommand("/core-service=management:read-children-names(child-type=management-interface)");
        for (ModelNode c : check.get("result").asList()) {
            if (!c.asString().equals("http-interface")) continue;
            result.add(this.submitCommand(undefineHttp));
            result.add(this.submitCommand(defineHttps));
        }
        return result;
    }

    private String prepareCommand(String cmd) {
        if (this.isDomain) {
            if (cmd.contains("subsystem")) {
                cmd = "/profile=%s" + cmd;
                return cmd;
            }
            if (cmd.contains(RELOAD_CMD)) {
                cmd = "reload --admin-only=true --host=" + ServerCommands.getDomainHostname();
                return cmd;
            }
            if (cmd.contains("core-service") || cmd.contains(SHUTDOWN_CMD)) {
                cmd = String.format(DOMAIN_CMD_PREFIX, ServerCommands.getDomainHostname()) + cmd;
                return cmd;
            }
            return cmd;
        }
        return cmd;
    }

    public ModelNode submitCommand(String cmd) {
        ModelNode result = null;
        cmd = this.prepareCommand(cmd);
        if (this.isDomain) {
            if (cmd.contains("subsystem")) {
                for (String profile : this.domainProfiles) {
                    String formattedCmd = String.format(cmd, profile);
                    result = this.addToLoggerAndHandle(formattedCmd);
                }
            } else {
                result = this.addToLoggerAndHandle(cmd);
            }
        } else {
            result = this.addToLoggerAndHandle(cmd);
        }
        return result;
    }

    private ModelNode addToLoggerAndHandle(String command) {
        ModelNode result = null;
        this.naiveLogger.add(command);
        if (this.context.getControllerHost() != null || !this.context.isBatchMode()) {
            this.context.handleSafe(command);
        }
        if (this.context.getExitCode() == 0) {
            // empty if block
        }
        return result;
    }

    public List<ModelNode> runCommandsInList(List<String> commands) {
        ArrayList<ModelNode> ret = new ArrayList<ModelNode>();
        for (String cmd : commands) {
            ModelNode result = this.submitCommand(cmd);
            ret.add(result);
        }
        return ret;
    }

    public List<ModelNode> installJdbcDriver(String jdbcName, String jdbcModuleName, String jdbcXaDsName) {
        ArrayList<ModelNode> results = new ArrayList<ModelNode>();
        String addJdbcCmd = "/subsystem=datasources/jdbc-driver=" + jdbcName + ":add(driver-name=\"" + jdbcName + "\",driver-module-name=\"" + jdbcModuleName + "\",driver-xa-datasource-class-name=\"" + jdbcXaDsName + "\")";
        this.submitCommand(addJdbcCmd);
        return results;
    }

    public List<ModelNode> installXaDatasourceUsernamePwd(String dsName, String dsJndiName, String driverName, String dsMinPool, String dsMaxPool, String dsUsername, String dsPassword, Map<String, String> xaProps, String dsXaRecoveryUser, String dsXaRecoveryPass, String jta) {
        return this.installDatasource(dsName, dsJndiName, driverName, null, dsMinPool, dsMaxPool, null, dsUsername, dsPassword, xaProps, dsXaRecoveryUser, dsXaRecoveryPass, jta);
    }

    public List<ModelNode> installXaDatasourceSecurityDomain(String dsName, String dsJndiName, String driverName, String dsMinPool, String dsMaxPool, String dsSecurityDomain, Map<String, String> xaProps, String dsXaRecoveryUser, String dsXaRecoveryPass, String jta) {
        return this.installDatasource(dsName, dsJndiName, driverName, null, dsMinPool, dsMaxPool, dsSecurityDomain, null, null, xaProps, dsXaRecoveryUser, dsXaRecoveryPass, jta);
    }

    public List<ModelNode> installDatasourceUsernamePwd(String dsName, String dsJndiName, String driverName, String connectionUrl, String dsMinPool, String dsMaxPool, String dsUsername, String dsPassword, String jta) {
        return this.installDatasource(dsName, dsJndiName, driverName, connectionUrl, dsMinPool, dsMaxPool, null, dsUsername, dsPassword, null, null, null, jta);
    }

    public List<ModelNode> installDatasourceSecurityDomain(String dsName, String dsJndiName, String driverName, String connectionUrl, String dsMinPool, String dsMaxPool, String dsSecurityDomain, String jta) {
        return this.installDatasource(dsName, dsJndiName, driverName, connectionUrl, dsMinPool, dsMaxPool, dsSecurityDomain, null, null, null, null, null, jta);
    }

    public List<ModelNode> installDatasourceSecurityDomainMinimal(String dsName, String dsJndiName, String driverName, String connectionUrl, String dsSecurityDomain) {
        return this.installDatasource(dsName, dsJndiName, driverName, connectionUrl, null, null, dsSecurityDomain, null, null, null, null, null, null);
    }

    public List<ModelNode> installDatasourceUserPwdMinimal(String dsName, String dsJndiName, String driverName, String connectionUrl, String dsUsername, String dsPassword) {
        return this.installDatasource(dsName, dsJndiName, driverName, connectionUrl, null, null, null, dsUsername, dsPassword, null, null, null, null);
    }

    private List<ModelNode> installDatasource(String dsName, String dsJndiName, String driverName, String connectionUrl, String dsMinPool, String dsMaxPool, String dsSecurityDomain, String dsUsername, String dsPassword, Map<String, String> xaProps, String dsXaRecoveryUser, String dsXaRecoveryPass, String jta) {
        boolean dsIsXa = false;
        String addDsCmd = "";
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (dsName == null || dsJndiName == null || driverName == null) {
            result.add(this.getFailureResult("ServerCommands.installDatasource()", "Add data-source command missing required values, one of 'dsName, dsJndiName, driverName'."));
            return result;
        }
        if (connectionUrl == null && xaProps == null) {
            result.add(this.getFailureResult("ServerCommands.installDatasource()", "Add data-source command missing either xa properties or connection url."));
            return result;
        }
        if (dsSecurityDomain == null && dsUsername == null && dsPassword == null) {
            result.add(this.getFailureResult("ServerCommands.installDatasource()", "Add data-source command missing either a security-domain or a user-name / password pair."));
            return result;
        }
        if (xaProps != null) {
            dsIsXa = true;
        }
        addDsCmd = addDsCmd + "add --enabled=true --name=" + dsName + " --jndi-name=\"" + dsJndiName + "\" --driver-name=" + driverName;
        if (dsMinPool != null) {
            addDsCmd = addDsCmd + " --min-pool-size=" + dsMinPool;
        }
        if (dsMaxPool != null) {
            addDsCmd = addDsCmd + " --max-pool-size=" + dsMaxPool;
        }
        if (jta != null) {
            addDsCmd = addDsCmd + " --jta=" + jta;
        }
        if (dsSecurityDomain != null) {
            addDsCmd = addDsCmd + " --security-domain=" + dsSecurityDomain;
        } else {
            if (this.hasVault() && dsPassword != null) {
                dsPassword = this.maskPassword("datasource." + dsName, "password", dsPassword);
            }
            addDsCmd = addDsCmd + " --user-name=" + dsUsername + " --password=\"" + dsPassword + "\"";
        }
        addDsCmd = this.setUniqueDsElements(addDsCmd, driverName);
        if (dsIsXa) {
            addDsCmd = addDsCmd + " --xa-datasource-properties=";
            for (String property : xaProps.keySet()) {
                if (xaProps.get(property) == null) continue;
                addDsCmd = addDsCmd + property + "," + xaProps.get(property) + ",";
            }
            addDsCmd = addDsCmd.substring(0, addDsCmd.length() - 1);
            if (driverName.equals("ibmdb2")) {
                addDsCmd = addDsCmd + " --recovery-plugin-class-name=org.jboss.jca.core.recovery.ConfigurableRecoveryPlugin --recovery-plugin-properties=EnabledIsValid=false,IsValidOverride=false,EnableClose=false";
            }
            if (this.hasVault() && dsXaRecoveryPass != null) {
                dsXaRecoveryPass = this.maskPassword("datasource." + dsName, "recoveryPassword", dsXaRecoveryPass);
            }
            if (dsXaRecoveryUser != null && dsXaRecoveryPass != null) {
                addDsCmd = addDsCmd + " --recovery-username=" + dsXaRecoveryUser + " --recovery-password=" + dsXaRecoveryPass;
            }
        } else {
            addDsCmd = addDsCmd + " --connection-url=\"" + connectionUrl + "\"";
        }
        if (this.isDomain) {
            addDsCmd = " --profile=%s " + addDsCmd;
        }
        addDsCmd = dsIsXa ? "xa-data-source " + addDsCmd : "data-source " + addDsCmd;
        if (this.isDomain) {
            for (String profile : this.domainProfiles) {
                result.add(this.addToLoggerAndHandle(String.format(addDsCmd, profile)));
            }
        } else {
            result.add(this.addToLoggerAndHandle(addDsCmd));
        }
        if (ServerCommandsHelper.findFailures(result).isEmpty()) {
            String enableCmd = "";
            if (this.isDomain) {
                enableCmd = "/profile=%s";
            }
            enableCmd = dsIsXa ? enableCmd + "/subsystem=datasources/xa-data-source=" + dsName + ":enable" : enableCmd + "/subsystem=datasources/data-source=" + dsName + ":enable";
            if (this.isDomain) {
                for (String profile : this.domainProfiles) {
                    result.add(this.addToLoggerAndHandle(String.format(enableCmd, profile)));
                }
            } else {
                result.add(this.addToLoggerAndHandle(enableCmd));
            }
        }
        return result;
    }

    private String setUniqueDsElements(String addDsCmd, String driverName) {
        String dsStaleChecker;
        String dsValidChecker;
        String dsExceptionSorter;
        if (driverName.equals("ibmdb2")) {
            dsExceptionSorter = "org.jboss.jca.adapters.jdbc.extensions.db2.DB2ExceptionSorter";
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.db2.DB2ValidConnectionChecker";
            dsStaleChecker = "org.jboss.jca.adapters.jdbc.extensions.db2.DB2StaleConnectionChecker";
        } else if (driverName.equals("sybase")) {
            dsExceptionSorter = "org.jboss.jca.adapters.jdbc.extensions.sybase.SybaseExceptionSorter";
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.sybase.SybaseValidConnectionChecker";
            dsStaleChecker = null;
        } else if (driverName.equals("mysql")) {
            dsExceptionSorter = "org.jboss.jca.adapters.jdbc.extensions.mysql.MySQLExceptionSorter";
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.mysql.MySQLValidConnectionChecker";
            dsStaleChecker = null;
        } else if (driverName.equals("postgresql")) {
            dsExceptionSorter = "org.jboss.jca.adapters.jdbc.extensions.postgres.PostgreSQLExceptionSorter";
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.postgres.PostgreSQLValidConnectionChecker";
            dsStaleChecker = null;
        } else if (driverName.equals("sqlserver")) {
            dsExceptionSorter = null;
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.mssql.MSSQLValidConnectionChecker";
            dsStaleChecker = null;
        } else if (driverName.equals("oracle")) {
            dsExceptionSorter = "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleExceptionSorter";
            dsValidChecker = "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleValidConnectionChecker";
            dsStaleChecker = "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleStaleConnectionChecker";
        } else {
            dsExceptionSorter = null;
            dsValidChecker = null;
            dsStaleChecker = null;
        }
        if (dsExceptionSorter != null) {
            addDsCmd = addDsCmd + " --exception-sorter-class-name=" + dsExceptionSorter;
        }
        if (dsValidChecker != null) {
            addDsCmd = addDsCmd + " --valid-connection-checker-class-name=" + dsValidChecker;
        }
        if (dsStaleChecker != null) {
            addDsCmd = addDsCmd + " --stale-connection-checker-class-name=" + dsStaleChecker;
        }
        return addDsCmd;
    }

    public List<ModelNode> installLdap(String ldapName, String ldapPassword, String ldapUrl, String ldapAuthDn, String ldapRealmName, String ldapBaseDn, String ldapFilter, String ldapRecursive, boolean isAdvancedFilter) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        result.addAll(this.createLdapConn(ldapName, ldapPassword, ldapUrl, ldapAuthDn));
        if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
            return result;
        }
        result.addAll(this.createLdapSecurityRealm(ldapName, ldapRealmName, ldapBaseDn, ldapFilter, ldapRecursive, isAdvancedFilter));
        if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
            return result;
        }
        result.addAll(this.installLdapToInterfaces(ldapRealmName));
        return result;
    }

    public List<ModelNode> createLdapConn(String ldapName, String ldapPwd, String ldapUrl, String ldapDn) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        String addLdapConnCmd = "/core-service=management/ldap-connection=" + ldapName + "/:add(search-credential=\"" + ldapPwd + "\",url=\"" + ldapUrl + "\",search-dn=\"" + ldapDn + "\")";
        result.add(this.submitCommand(addLdapConnCmd));
        return result;
    }

    public List<ModelNode> createLdapSecurityRealm(String ldapName, String ldapRealmName, String ldapBaseDn, String ldapFilter, String ldapRecursive, boolean isAdvancedFilter) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        String createLdapSecRealmCmd = "/core-service=management/security-realm=\"" + ldapRealmName + "\":add";
        String addLdapSecRealmCmd = "/core-service=management/security-realm=\"" + ldapRealmName + "\"/authentication=ldap:add(base-dn=\"" + ldapBaseDn + "\", recursive=\"" + ldapRecursive + "\", connection=\"" + ldapName + "\"";
        addLdapSecRealmCmd = isAdvancedFilter ? addLdapSecRealmCmd + ",advanced-filter=\"" + ldapFilter + "\")" : addLdapSecRealmCmd + ",username-attribute=\"" + ldapFilter + "\")";
        result.add(this.submitCommand(createLdapSecRealmCmd));
        if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
            return result;
        }
        result.add(this.submitCommand(addLdapSecRealmCmd));
        return result;
    }

    public List<ModelNode> writeSecurityRealmAttribute(String interfaceName, String realmName) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        String checkCmd = "/core-service=management:read-children-names(child-type=management-interface)";
        ModelNode check = this.submitCommand(checkCmd);
        for (ModelNode c : check.get("result").asList()) {
            if (!c.asString().equals(interfaceName)) continue;
            String writeSecurityRealmCmd = "/core-service=management/management-interface=" + interfaceName + "/:" + this.writeAttribute("security-realm", "\"" + realmName + "\"");
            result.add(this.submitCommand(writeSecurityRealmCmd));
        }
        return result;
    }

    private List<ModelNode> installLdapToHttpInterface(String ldapRealmName) {
        return this.writeSecurityRealmAttribute("http-interface", ldapRealmName);
    }

    private List<ModelNode> installLdapToNativeInterface(String ldapRealmName) {
        return this.writeSecurityRealmAttribute("native-interface", ldapRealmName);
    }

    public List<ModelNode> installLdapToInterfaces(String ldapRealmName) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        result.addAll(this.installLdapToHttpInterface(ldapRealmName));
        if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
            return result;
        }
        result.addAll(this.installLdapToNativeInterface(ldapRealmName));
        return result;
    }

    public void setContextLoggingConfig(String file) {
        System.setProperty("logging.configuration", file);
    }

    public void setCommandContext(CommandContext cc) {
        this.context = cc;
    }

    public void writeLogFile() throws IOException {
        BufferedWriter bw;
        if (this.logFilePath != null) {
            File logFile = new File(this.logFilePath);
            bw = new BufferedWriter(new FileWriter(logFile));
            for (String line : this.naiveLogger) {
                bw.write(line + "\n");
            }
        } else {
            throw new FileNotFoundException("writeLogFile: the logFileLocation has not been set");
        }
        bw.close();
    }

    public ModelNode reloadHost() {
        return this.submitCommand(RELOAD_CMD);
    }

    public ModelNode shutdownHost() {
        return this.submitCommand(SHUTDOWN_CMD);
    }

    public ModelNode shutdownDomainHost() {
        return this.submitCommand(String.format(DOMAIN_CMD_PREFIX, ServerCommands.getDomainHostname()) + SHUTDOWN_CMD);
    }

    public ModelNode runBatch() throws BatchNotActiveException, CommandLineException, BatchIsEmptyException {
        if (this.naiveLogger.isEmpty()) {
            throw new BatchIsEmptyException("ServerCommands: The batch is empty.");
        }
        if (this.context.getControllerHost() == null) {
            throw new CommandLineException("ServerCommands: You are not connected to any host. runBatch() can only be run while connected");
        }
        if (this.context.isBatchMode()) {
            return this.submitCommand(RUN_BATCH_CMD);
        }
        throw new BatchNotActiveException("ServerCommands: there is no currently active batch");
    }

    public ModelNode runBatch(String name) throws BatchNotActiveException, CommandLineException, BatchIsEmptyException {
        this.context.getBatchManager().activateHeldbackBatch(name);
        return this.runBatch();
    }

    public boolean isStoredBatch(String name) {
        return this.context.getBatchManager().isHeldback(name);
    }

    public ModelNode setTransactionManagerTimeout(int timeout) {
        String setTimeoutCmd = "";
        return this.submitCommand(setTimeoutCmd);
    }

    public List<ModelNode> createLoggerLevel(String name, String level, String useParentHandlers) {
        boolean useParents = useParentHandlers != null && useParentHandlers.equals("true");
        return this.createLoggerLevel(name, level, null, null, null, null, useParents);
    }

    public List<ModelNode> createLoggerLevel(String name, String level, String category, String filter, String filterSpec, String handlers, boolean useParentHandlers) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (name == null) {
            result.add(this.getFailureResult("ServerCommands.createLoggerLevel()", "The 'name' for the new logger was null."));
            return result;
        }
        String createLoggerCmd = "/subsystem=logging/logger=" + name + ":add(";
        if (level != null) {
            createLoggerCmd = createLoggerCmd + "level=" + level + ",";
        }
        if (category != null) {
            createLoggerCmd = createLoggerCmd + "category=" + category + ",";
        }
        if (filter != null) {
            createLoggerCmd = createLoggerCmd + "filter=" + filter + ",";
        }
        if (filterSpec != null) {
            createLoggerCmd = createLoggerCmd + "filter-spec=" + filterSpec + ",";
        }
        if (handlers != null) {
            createLoggerCmd = createLoggerCmd + "handlers=" + handlers + ",";
        }
        createLoggerCmd = useParentHandlers ? createLoggerCmd + "use-parent-handlers=true" : createLoggerCmd + "use-parent-handlers=false";
        result.add(this.submitCommand(createLoggerCmd));
        return result;
    }

    public List<ModelNode> addSecurityDomain(String domainName, String cacheType, List<String> authenCode, List<String> authenFlag, List<Map<String, String>> authenOptions, List<String> authorCode, List<String> authorFlag, List<Map<String, String>> authorOptions, List<String> mappingCode, List<String> mappingFlag, List<Map<String, String>> mappingOptions, Map<String, String> jsseAttrs, Map<String, String> jsseKeystoreAttrs, Map<String, String> jsseKeystoreManagerAttrs, Map<String, String> jsseTruststoreAttrs, Map<String, String> jsseTruststoreManagerAttrs, Map<String, String> jsseAdditionalProps) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        result.addAll(this.createSecurityDomain(domainName, cacheType));
        if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
            return result;
        }
        if (authenCode != null && authenFlag != null && !authenCode.isEmpty() && !authenFlag.isEmpty()) {
            result.addAll(this.addSecurityDomainAuthentication(domainName, authenCode, authenFlag, authenOptions));
            if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
                return result;
            }
        }
        if (authorCode != null && authorFlag != null && !authorCode.isEmpty() && !authorFlag.isEmpty()) {
            result.addAll(this.addSecurityDomainAuthorization(domainName, authorCode, authorFlag, authorOptions));
            if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
                return result;
            }
        }
        if (mappingCode != null && mappingFlag != null && !mappingCode.isEmpty() && !mappingFlag.isEmpty()) {
            result.addAll(this.addSecurityDomainMapping(domainName, mappingCode, mappingFlag, mappingOptions));
            if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
                return result;
            }
        }
        if (jsseAttrs != null || jsseKeystoreAttrs != null || jsseKeystoreManagerAttrs != null || jsseTruststoreAttrs != null || jsseTruststoreManagerAttrs != null) {
            result.addAll(this.addSecurityDomainJsse(domainName, jsseAttrs, jsseKeystoreAttrs, jsseKeystoreManagerAttrs, jsseTruststoreAttrs, jsseTruststoreManagerAttrs, jsseAdditionalProps));
            if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
                return result;
            }
        }
        return result;
    }

    private List<ModelNode> addSecurityDomainJsse(String domainName, Map<String, String> jsseAttrs, Map<String, String> jsseKeystoreAttrs, Map<String, String> jsseKeystoreManagerAttrs, Map<String, String> jsseTruststoreAttrs, Map<String, String> jsseTruststoreManagerAttrs, Map<String, String> jsseAdditionalProps) {
        String addSecurityDomainJsseCmd = "/subsystem=security/security-domain=" + domainName + "/jsse=classic:add(";
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (jsseAttrs != null) {
            for (Map.Entry<String, String> entry : jsseAttrs.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                addSecurityDomainJsseCmd = addSecurityDomainJsseCmd + entry.getKey() + "=\"" + entry.getValue() + "\",";
            }
        }
        if (jsseKeystoreAttrs != null) {
            addSecurityDomainJsseCmd = addSecurityDomainJsseCmd + this.listString(domainName, "keystore", jsseKeystoreAttrs);
            if (jsseKeystoreManagerAttrs != null) {
                addSecurityDomainJsseCmd = addSecurityDomainJsseCmd + this.listString(domainName, "key-manager", jsseKeystoreManagerAttrs);
            }
        }
        if (jsseTruststoreAttrs != null) {
            addSecurityDomainJsseCmd = addSecurityDomainJsseCmd + this.listString(domainName, "truststore", jsseTruststoreAttrs);
            if (jsseTruststoreManagerAttrs != null) {
                addSecurityDomainJsseCmd = addSecurityDomainJsseCmd + this.listString(domainName, "trust-manager", jsseTruststoreManagerAttrs);
            }
        }
        result.add(this.submitCommand(addSecurityDomainJsseCmd));
        return result;
    }

    private String listString(String domainName, String listName, Map<String, String> attributes) {
        String returnValue = listName + "={";
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            String value = entry.getValue();
            if (entry.getKey().contains("password") && this.hasVault()) {
                value = this.maskPassword(domainName + "." + listName, "password", value);
            }
            returnValue = returnValue + entry.getKey() + "=\"" + value.replaceAll("\\\\", "/") + "\",";
        }
        if ((returnValue = returnValue + "},").equals(listName + "={}")) {
            return "";
        }
        return returnValue;
    }

    List<ModelNode> createSecurityDomain(String domainName, String cacheType) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        String addSecurityDomainCmd = cacheType.equals("infinispan") || cacheType.equals("default") ? "/subsystem=security/security-domain=" + domainName + ":add(cache-type=" + cacheType + ")" : "/subsystem=security/security-domain=" + domainName + ":add()";
        result.add(this.submitCommand(addSecurityDomainCmd));
        return result;
    }

    private String completeSecurityDomainCmd(List<String> codes, List<String> flags, List<Map<String, String>> moduleOptions, String typeOrFlag) {
        String cmd = "";
        for (int i = 0; i < codes.size(); ++i) {
            if (i > 0) {
                cmd = cmd + ",";
            }
            cmd = cmd + "{\"code\"=>\"" + codes.get(i) + "\",\"" + typeOrFlag + "\"=>\"" + flags.get(i) + "\"";
            if (moduleOptions != null) {
                Map<String, String> moduleOption = moduleOptions.get(i);
                cmd = cmd + ",\"module-options\"=>[";
                for (String name : moduleOption.keySet()) {
                    cmd = cmd + "(\"" + name + "\"=>\"" + moduleOption.get(name) + "\"),";
                }
                cmd = cmd + "]}";
                continue;
            }
            cmd = cmd + "}";
        }
        cmd = cmd + "])";
        return cmd;
    }

    private String completeSecurityDomainCmd(List<String> codes, List<String> flags, List<Map<String, String>> moduleOptions) {
        return this.completeSecurityDomainCmd(codes, flags, moduleOptions, "flag");
    }

    List<ModelNode> addSecurityDomainAuthentication(String domainName, List<String> codes, List<String> flags, List<Map<String, String>> moduleOptions) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (codes.size() == 0) {
            result.add(this.getFailureResult("ServerCommands.addSecurityDomainAuthentication()", "Code element is empty."));
            return result;
        }
        if (codes.size() != flags.size() || flags.size() != moduleOptions.size()) {
            result.add(this.getFailureResult("ServerCommands.addSecurityDomainAuthentication()", "Mismatch of code / flags / options sizes."));
            return result;
        }
        String addSecurityDomainAuthCmd = "/subsystem=security/security-domain=" + domainName + "/authentication=classic:add(login-modules=[";
        for (int i = 0; i < codes.size(); ++i) {
            if (this.invalidCodes(codes.get(i), this.validAuthenticationCodes)) {
                result.add(this.getFailureResult("ServerCommands.addSecurityDomainAuthentication()", String.format("The value for authentication code \"%s\" is not valid.", codes.get(i))));
                return result;
            }
            if (!this.invalidCodes(flags.get(i), this.validFlags)) continue;
            result.add(this.getFailureResult("ServerCommands.addSecurityDomainAuthentication()", String.format("The value for flag \"%s\" is not valid. It must be one of: \"Required\", \"Requisite\", \"Sufficient\", \"Optional\"", flags.get(i))));
            return result;
        }
        addSecurityDomainAuthCmd = addSecurityDomainAuthCmd + this.completeSecurityDomainCmd(codes, flags, moduleOptions);
        result.add(this.submitCommand(addSecurityDomainAuthCmd));
        return result;
    }

    List<ModelNode> addSecurityDomainAuthorization(String domainName, List<String> codes, List<String> flags, List<Map<String, String>> moduleOptions) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (codes.size() == 0) {
            result.add(this.getFailureResult("ServerCommands.addSecurityDomainAuthorization()", "Code element is empty."));
            return result;
        }
        if (codes.size() != flags.size() || flags.size() != moduleOptions.size()) {
            result.add(this.getFailureResult("ServerCommands.addSecurityDomainAuthorization()", "Mismatch of code / flags / options sizes."));
            return result;
        }
        String addSecurityDomainAuthCmd = "/subsystem=security/security-domain=" + domainName + "/authorization=classic:add(policy-modules=[";
        for (int i = 0; i < codes.size(); ++i) {
            if (this.invalidCodes(codes.get(i), this.validAuthorizationCodes)) {
                result.add(this.getFailureResult("ServerCommands.addSecurityDomainAuthorization()", String.format("The value for authentication code %s is not valid.", codes.get(i))));
                return result;
            }
            if (!this.invalidCodes(flags.get(i), this.validFlags)) continue;
            result.add(this.getFailureResult("ServerCommands.addSecurityDomainAuthorization()", String.format("The value for flag %s is not valid.", flags.get(i))));
            return result;
        }
        addSecurityDomainAuthCmd = addSecurityDomainAuthCmd + this.completeSecurityDomainCmd(codes, flags, moduleOptions);
        result.add(this.submitCommand(addSecurityDomainAuthCmd));
        return result;
    }

    public List<ModelNode> addSecurityDomainAuthenOnly(String domainName, String cacheType, List<String> authenCodes, List<String> authenFlags, List<Map<String, String>> authenOptions) {
        return this.addSecurityDomain(domainName, cacheType, authenCodes, authenFlags, authenOptions, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public List<ModelNode> addSecurityDomainAuthorOnly(String domainName, String cacheType, List<String> authorCodes, List<String> authorFlags, List<Map<String, String>> authorOptions) {
        return this.addSecurityDomain(domainName, cacheType, null, null, null, authorCodes, authorFlags, authorOptions, null, null, null, null, null, null, null, null, null);
    }

    public List<ModelNode> addSecurityDomainMappingOnly(String domainName, String cacheType, List<String> mappingCodes, List<String> mappingFlags, List<Map<String, String>> mappingOptions) {
        return this.addSecurityDomain(domainName, cacheType, null, null, null, null, null, null, mappingCodes, mappingFlags, mappingOptions, null, null, null, null, null, null);
    }

    List<ModelNode> addSecurityDomainMapping(String domainName, List<String> codes, List<String> types, List<Map<String, String>> moduleOptions) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (codes.size() == 0) {
            result.add(this.getFailureResult("ServerCommands.addSecurityDomainMapping()", "Code element is empty."));
            return result;
        }
        if (codes.size() != types.size() || types.size() != moduleOptions.size()) {
            result.add(this.getFailureResult("ServerCommands.addSecurityDomainMapping()", "Mismatch of code / flags / options sizes."));
            return result;
        }
        String addSecurityDomainMappingCmd = "/subsystem=security/security-domain=" + domainName + "/mapping=classic:add(mapping-modules=[";
        for (int i = 0; i < codes.size(); ++i) {
            if (this.invalidCodes(codes.get(i), this.validMappingCodes)) {
                result.add(this.getFailureResult("ServerCommands.addSecurityDomainMapping()", String.format("The value for authentication code \"%s\" is not valid.", codes.get(i))));
                return result;
            }
            if (!this.invalidCodes(types.get(i), this.validTypes)) continue;
            result.add(this.getFailureResult("ServerCommands.addSecurityDomainMapping()", String.format("The value for flag \"%s\" is not valid. It must be one of: \"principal\", \"credential\", \"role\", \"attribute\"", types.get(i))));
            return result;
        }
        addSecurityDomainMappingCmd = addSecurityDomainMappingCmd + this.completeSecurityDomainCmd(codes, types, moduleOptions, "type");
        result.add(this.submitCommand(addSecurityDomainMappingCmd));
        return result;
    }

    private boolean invalidCodes(String code, String[] codes) {
        for (String a : codes) {
            if (!code.equals(a)) continue;
            return false;
        }
        return true;
    }

    public ModelNode modifyHttpRedirectPort(String port) {
        String modifyPortCmd = "/subsystem=web/connector=http:" + this.writeAttribute("redirect-port", port);
        return this.submitCommand(modifyPortCmd);
    }

    public ModelNode disableWelcomeScreen() {
        String disableWelcomeCmd = "/subsystem=web/virtual-server=default-host:" + this.writeAttribute("enable-welcome-root", "false");
        return this.submitCommand(disableWelcomeCmd);
    }

    public ModelNode writeSmtpPort(String port) {
        String writeSmtpPortCmd = "/socket-binding-group=full-sockets/remote-destination-outbound-socket-binding=mail-smtp:" + this.writeAttribute(port, "${rhq.server.email.smtp-port:25}");
        return this.submitCommand(writeSmtpPortCmd);
    }

    private String writeAttribute(String name, String value) {
        return "write-attribute(name=" + name + ", value=" + value + ")";
    }

    public List<ModelNode> addJmsQueue(String address, List<String> entries, boolean durable, List<String> headers, String selector) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (!this.isDomain) {
            result.add(this.getFailureResult("ServerCommands.addJmsQueue()", "A JMS queue cannot be added to a non-domain server."));
            return result;
        }
        if (address == null) {
            result.add(this.getFailureResult("ServerCommands.addJmsQueue()", "The 'address' was null."));
            return result;
        }
        if (entries == null || entries.size() == 0) {
            result.add(this.getFailureResult("ServerCommands.addJmsQueue()", "There were no entries for the 'entries' element."));
            return result;
        }
        String addJmsQueueCmd = "jms-queue --profile=" + this.domainProfiles + " add --queue-address=" + address + " --entries=";
        for (String entry : entries) {
            addJmsQueueCmd = addJmsQueueCmd + entry + ",";
        }
        addJmsQueueCmd = durable ? addJmsQueueCmd + " --durable=true" : addJmsQueueCmd + " --durable=false";
        if (headers != null) {
            for (String string : headers) {
            }
        }
        if (selector != null) {
            addJmsQueueCmd = addJmsQueueCmd + " --selector=" + selector;
        }
        this.naiveLogger.add(addJmsQueueCmd);
        result.add(this.addToLoggerAndHandle(addJmsQueueCmd));
        return result;
    }

    public List<ModelNode> addInfinispanCache(String name, String jndiName, String localCacheName, String transactionMode, String evictionStrategy, String evictionMaxEntries, String expirationMaxIdle) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        result.addAll(this.createInfinispanContainer(name, jndiName));
        if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
            return result;
        }
        result.addAll(this.addInfinispanLocalCache(name, localCacheName));
        if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
            return result;
        }
        result.addAll(this.addInfinispanEviction(name, localCacheName, evictionStrategy, evictionMaxEntries));
        if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
            return result;
        }
        result.addAll(this.addInfinispanTransaction(name, localCacheName, transactionMode));
        if (!ServerCommandsHelper.findFailures(result).isEmpty()) {
            return result;
        }
        result.addAll(this.addInfinispanExpiration(name, localCacheName, expirationMaxIdle));
        return result;
    }

    private List<ModelNode> createInfinispanContainer(String name, String jndiName) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (name == null || jndiName == null) {
            result.add(this.getFailureResult("ServerCommands.createInfinispanContainer()", "Either the 'name' or 'jndiName' element were null."));
            return result;
        }
        String addInfinispanContainerCmd = "/subsystem=infinispan/cache-container=" + name + ":add(jndi-name=\"" + jndiName + "\")";
        result.add(this.submitCommand(addInfinispanContainerCmd));
        return result;
    }

    private List<ModelNode> addInfinispanLocalCache(String name, String localCacheName) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (localCacheName == null) {
            result.add(this.getFailureResult("ServerCommands.addInfinispanLocalCache()", "The local-cache attribute was null."));
            return result;
        }
        String addInfinispanLocalCacheCmd = "/subsystem=infinispan/cache-container=" + name + "/local-cache=" + localCacheName + ":add()";
        result.add(this.submitCommand(addInfinispanLocalCacheCmd));
        return result;
    }

    private List<ModelNode> addInfinispanEviction(String name, String localCacheName, String evictionStrategy, String evictionMaxEntries) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (evictionMaxEntries != null) {
            try {
                Integer.parseInt(evictionMaxEntries);
            }
            catch (NumberFormatException e) {
                result.add(this.getFailureResult("ServerCommands.addInfinispanEviction()", "The value for the 'max-entries' element was not a number."));
                return result;
            }
        }
        String addInfinispanEvictionCmd = "/subsystem=infinispan/cache-container=" + name + "/local-cache=" + localCacheName + "/eviction=EVICTION:add(strategy=" + evictionStrategy + ",max-entries=" + evictionMaxEntries + ")";
        result.add(this.submitCommand(addInfinispanEvictionCmd));
        return result;
    }

    private List<ModelNode> addInfinispanTransaction(String name, String localCacheName, String transactionMode) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        String addInfinispanTransactionCmd = "/subsystem=infinispan/cache-container=" + name + "/local-cache=" + localCacheName + "/transaction=TRANSACTION:add(mode=" + transactionMode + ")";
        result.add(this.submitCommand(addInfinispanTransactionCmd));
        return result;
    }

    private List<ModelNode> addInfinispanExpiration(String name, String localCacheName, String expirationMaxIdle) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        if (expirationMaxIdle != null) {
            try {
                Integer.parseInt(expirationMaxIdle);
            }
            catch (NumberFormatException e) {
                result.add(this.getFailureResult("ServerCommands.addInfinispanExpiration()", "The value for the 'max-idle' element was not a number."));
                return result;
            }
        }
        String addInfinispanExpirationCmd = "/subsystem=infinispan/cache-container=" + name + "/local-cache=" + localCacheName + "/expiration=EXPIRATION:add(max-idle=" + expirationMaxIdle + ")";
        result.add(this.submitCommand(addInfinispanExpirationCmd));
        return result;
    }

    public void setLogger(Logger logger2) {
        this.logger = logger2;
        logger2.info("Running commands from: " + logger2.getName());
    }

    private List<ModelNode> writeSocketBindingAttribute(String socketBindingGroupName, String socketBindingName, String attributeName, String variable) {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        String writeSocketBindingCmd = "/socket-binding-group=" + socketBindingGroupName + "/socket-binding=" + socketBindingName + ":write-attribute(name=" + attributeName + ",value=" + variable + ")";
        result.add(this.submitCommand(writeSocketBindingCmd));
        return result;
    }

    public List<ModelNode> writeSocketBindingPort(String socketBindingGroupName, String socketBindingName, String variable) {
        return this.writeSocketBindingAttribute(socketBindingGroupName, socketBindingName, "port", variable);
    }

    public List<ModelNode> writeSocketBindingMulticastPort(String socketBindingGroupName, String socketBindingName, String variable) {
        return this.writeSocketBindingAttribute(socketBindingGroupName, socketBindingName, "multicast-port", variable);
    }

    public Collection<? extends ModelNode> writeSocketBindingMulticastAddress(String socketBindingGroupName, String socketBindingName, String variable) {
        return this.writeSocketBindingAttribute(socketBindingGroupName, socketBindingName, "multicast-address", variable);
    }

    public ModelNode writeStandalonePortOffset(String variable) {
        variable = "${jboss.socket.binding.port-offset:" + variable + "}";
        String writePortOffsetCmd = "/socket-binding-group=standard-sockets:write-attribute(name=port-offset,value=" + variable + ")";
        return this.submitCommand(writePortOffsetCmd);
    }

    public List<ModelNode> writeDomainPortOffset(String variable) {
        ArrayList<ModelNode> cmdResults = new ArrayList<ModelNode>();
        cmdResults.addAll(this.configureServer("server-one", variable));
        cmdResults.addAll(this.configureServer("server-two", variable));
        cmdResults.addAll(this.configureServer("server-three", variable));
        return cmdResults;
    }

    private List<ModelNode> configureServer(String serverName, String offSet) {
        ArrayList<ModelNode> cmdResults = new ArrayList<ModelNode>();
        String writePortOffsetCmd = "/host=master/server-config=" + serverName + ":read-attribute(name=socket-binding-port-offset)";
        ModelNode result = this.submitCommand(writePortOffsetCmd);
        cmdResults.add(result);
        String existingOffset = this.getOffsetValue(result);
        String fullOffset = this.getNewOffset(existingOffset, offSet);
        result = this.submitCommand("/host=master/server-config=" + serverName + ":write-attribute(name=socket-binding-port-offset,value=" + fullOffset + ")");
        cmdResults.add(result);
        return cmdResults;
    }

    private String getOffsetValue(ModelNode result) {
        List<Property> properties = result.asPropertyList();
        String existingOffset = null;
        for (Property property : properties) {
            if (!property.getName().equals("result")) continue;
            existingOffset = property.getValue().toString();
            break;
        }
        return existingOffset;
    }

    private String getNewOffset(String existingOffset, String newOffset) {
        int intExistingOffset = Integer.parseInt(existingOffset);
        int intNewOffset = Integer.parseInt(newOffset);
        int completeOffset = intExistingOffset + intNewOffset;
        return "" + completeOffset;
    }

    public List<ModelNode> writeLoggingLevel(String level, String group) {
        ArrayList<ModelNode> cmdResults = new ArrayList<ModelNode>();
        String groupValue = group.equals("console-handler") ? "CONSOLE" : "ROOT";
        String writeLoggingLevelCmd = String.format("/subsystem=logging/%s=%s:write-attribute(name=level,value=%s)", group, groupValue, level);
        ModelNode result = this.submitCommand(writeLoggingLevelCmd);
        cmdResults.add(result);
        return cmdResults;
    }

    void readPropertiesFile(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        System.getProperties().load(inStream);
    }

    public void readPropertiesFile(String path) throws IOException {
        this.readPropertiesFile(new File(path));
    }

    public void disconnect() {
        this.context.disconnectController();
    }

    private static void addEnv(Map<String, String> newenv) {
        ServerCommands.setEnv(newenv, true);
    }

    private static void setEnv(Map<String, String> newenv, boolean append) {
        Map<String, String> env = System.getenv();
        if (append) {
            for (String string : env.keySet()) {
                if (newenv.get(string) != null) continue;
                newenv.put(string, env.get(string));
            }
        }
        Class<?>[] classes = Collections.class.getDeclaredClasses();
        try {
            for (Class<?> cl : classes) {
                if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                Field field = cl.getDeclaredField("m");
                field.setAccessible(true);
                Object obj = field.get(env);
                Map map = (Map)obj;
                map.clear();
                map.putAll(newenv);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addProperties(String[] properties) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        for (String prop : properties) {
            System.getProperties().setProperty(prop, idata.getVariable(prop));
        }
    }

    private ModelNode handle(String command) throws CommandFormatException, IOException {
        if (this.logger != null) {
            this.logger.info(command);
        }
        ModelControllerClient mcc = this.context.getModelControllerClient();
        ModelNode request = this.context.buildRequest(command);
        ModelNode returnValue = mcc != null ? mcc.execute(request) : this.getFailureResult(command, "No ModelControllerClient was available to execute the request.");
        return returnValue;
    }

    private ModelNode getFailureResult(String cmd, String failureMsg) {
        ModelNode failedNode = new ModelNode();
        failedNode.get("outcome").set("failed");
        failedNode.get("failure-description").set(failureMsg);
        ServerCommandsHelper.setCommand(failedNode, cmd);
        return failedNode;
    }

    public VaultSession getVaultSession() {
        return vault;
    }

    public boolean isBatchMode() {
        return this.context.isBatchMode();
    }

    public static void setDomainHostname(String name) {
        domainHostname = name;
    }

    public static String getDomainHostname() {
        return domainHostname;
    }

    public boolean isDomain() {
        return this.isDomain;
    }

    public class BatchIsEmptyException
    extends Exception {
        private static final long serialVersionUID = 8465278229646760882L;

        public BatchIsEmptyException() {
        }

        public BatchIsEmptyException(String s) {
            super(s);
        }
    }

    public class BatchNotActiveException
    extends Exception {
        private static final long serialVersionUID = -5463741947772468327L;

        public BatchNotActiveException(String m) {
            super(m);
        }

        public BatchNotActiveException() {
        }
    }
}

