/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ascontroller;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.EmbeddedServerCommands;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommands;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;

public class ServerCommandsHelper {
    private static final String TIMEOUT = "timeout";
    private static final String ATTEMPTS = "attempts";
    public static int DEFAULT_TIME_TO_SLEEP = 0;
    public static int DEFAULT_CONN_ATTEMPTS = 5;
    private static final Set<String> unsupportedCliCommands = new HashSet<String>();

    public static void connectContext(AbstractUIProcessHandler mHandler, ServerCommands serverCommands, int timeToSleep, int attemptLimit) throws InterruptedException {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        int attempts = 0;
        String connectSuccess = idata.langpack.getString("postinstall.processpanel.management.connectSuccess");
        String connectFail = idata.langpack.getString("postinstall.processpanel.management.connectFail");
        String connectAttempt = idata.langpack.getString("postinstall.processpanel.management.connecting");
        while (attempts < attemptLimit) {
            if (mHandler != null) {
                ProcessPanelHelper.printToPanel(mHandler, String.format(connectAttempt, attempts + 1, attemptLimit), false);
            }
            try {
                Thread.sleep(timeToSleep * 1000);
                serverCommands.connectContext();
            }
            catch (CommandLineException e) {
                if (++attempts < attemptLimit) continue;
                if (mHandler != null) {
                    ProcessPanelHelper.printToPanel(mHandler, String.format(connectFail, attempts), false);
                }
                return;
            }
            if (mHandler == null) break;
            ProcessPanelHelper.printToPanel(mHandler, connectSuccess, false);
            break;
        }
    }

    public static void connectContext(AbstractUIProcessHandler mHandler, ServerCommands serverCommands) throws InterruptedException {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String customTimeout = idata.getVariable(TIMEOUT);
        String customAttemptLimit = idata.getVariable(ATTEMPTS);
        int attemptLimit = customAttemptLimit != null ? Integer.parseInt(customAttemptLimit) : DEFAULT_CONN_ATTEMPTS;
        int timeToSleep = customTimeout != null ? Integer.parseInt(customTimeout) : DEFAULT_TIME_TO_SLEEP;
        ServerCommandsHelper.connectContext(mHandler, serverCommands, timeToSleep, attemptLimit);
    }

    public static List<ModelNode> findFailures(List<ModelNode> list) {
        ArrayList<ModelNode> failureList = new ArrayList<ModelNode>();
        for (ModelNode result : list) {
            if (Operations.isSuccessfulOutcome(result)) continue;
            failureList.add(result);
        }
        return failureList;
    }

    public static Logger createLogger(String name, EmbeddedServerCommands sc) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String logFile = idata.getVariable("installation.logfile");
        if (logFile == null) {
            return null;
        }
        String logPath = idata.getInstallPath() + File.separator + logFile;
        Logger logger2 = Logger.getLogger(name);
        logger2.setUseParentHandlers(false);
        FileHandler h = null;
        try {
            h = new FileHandler(logPath, true);
        }
        catch (IOException e) {
            return null;
        }
        h.setFormatter(new SimpleFormatter());
        h.setLevel(Level.INFO);
        logger2.addHandler(h);
        logger2.setLevel(Level.INFO);
        if (sc != null) {
            sc.setLogger(logger2);
        }
        return logger2;
    }

    public static Logger createLogger(String name) {
        return ServerCommandsHelper.createLogger(name, null);
    }

    public static boolean findRealFailures(List<ModelNode> failures) {
        return false;
    }

    public static List<String> loadCommandsIntoList(String path, boolean hasDeployCommand) {
        return ServerCommandsHelper.loadCommandsIntoList(new File(path), hasDeployCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadCommandsIntoList(File file, boolean hasDeployCommand) {
        ArrayList<String> commands = new ArrayList<String>();
        String line = "";
        boolean deployRemoved = false;
        if (hasDeployCommand) {
            unsupportedCliCommands.remove("deploy");
            deployRemoved = true;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                String cmd = "";
                if (ServerCommandsHelper.unsupportedCommand(line)) continue;
                while (line.trim().endsWith("\\")) {
                    cmd = cmd + line.trim().substring(0, line.trim().indexOf("\\"));
                    line = br.readLine();
                }
                if ((cmd = cmd + line.trim()).startsWith("deploy")) {
                    cmd = ServerCommandsHelper.buildDeployCommand(cmd);
                }
                commands.add(cmd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    ProcessPanelHelper.printToLog("Failed to close BufferedReader: " + br.toString());
                    ProcessPanelHelper.printExceptionToLog(e.getStackTrace());
                }
            }
        }
        if (deployRemoved) {
            unsupportedCliCommands.add("deploy");
        }
        return commands;
    }

    private static String buildDeployCommand(String cmd) {
        String[] cmdArray = cmd.split(" ");
        String installPath = AutomatedInstallData.getInstance().getInstallPath();
        if (!installPath.endsWith(File.separator)) {
            installPath = installPath + File.separator;
        }
        File normalizedPath = new File(installPath + cmdArray[1]);
        cmdArray[1] = normalizedPath.getAbsolutePath();
        String builtCommand = "";
        for (String cmdPart : cmdArray) {
            builtCommand = builtCommand + cmdPart + " ";
        }
        return builtCommand;
    }

    private static boolean unsupportedCommand(String cmd) {
        if (cmd.trim().startsWith("#") || cmd.trim().isEmpty()) {
            return true;
        }
        for (String prefix : unsupportedCliCommands) {
            if (!cmd.trim().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String getCommand(ModelNode node) {
        return node.get("command").asString();
    }

    public static ModelNode setCommand(ModelNode node, String cmd) {
        return node.get("command").set(cmd);
    }

    static {
        unsupportedCliCommands.add("batch");
        unsupportedCliCommands.add("run-batch");
        unsupportedCliCommands.add("connect");
        unsupportedCliCommands.add("deploy");
    }
}

