/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ascontroller;

import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommands;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.asconfiguration.ascontroller.ServerScriptLauncher;
import com.redhat.installer.asconfiguration.processpanel.PostInstallUserHelper;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import com.redhat.installer.ports.utils.PortReader;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;

public class ServerManager
extends SimpleInstallerListener
implements CleanupClient {
    public static final String UP = "up";
    public static final String DOWN = "down";
    private static volatile String STATUS = "down";
    public static final String STARTING = "starting";
    public static final String UNKNOWN = "unknown";
    public static final String DOMAIN = "domain";
    public static final String STANDALONE = "standalone";
    private static String MODE = "standalone";
    public static String CODE_START_OK = "JBAS015874";
    public static String CODE_START_ERROR = "JBAS015875";
    public static String CODE_STOP_OK = "JBAS015950";
    public static String CODE_PROCESS_FINISH = "JBAS012015";
    public static String CODE_HOST_FINISH = "JBAS012010";
    public static String CODE_SSL_SERVER = "JBAS015962";
    private static final String MSG_STARTING_SERVER = "postinstall.processpanel.startingServer";
    private static final String MSG_SERVER_STARTED = "postinstall.processpanel.serverStarted";
    private static final String MSG_SERVER_STARTED_WITH_ERRORS = "postinstall.processpanel.serverStartedWithErrors";
    private static final String POSTINSTALL_SCRIPT = "postinstall-script";
    private static final String SERVER_SCRIPT = "server-script";
    private static final String STANDALONE_CONFIG = "standalone-config";
    private static final String HOST_CONFIG = "host-config";
    private static final String ONFAIL_JOB = "failmode";
    private static final String TIMEOUT = "timeout";
    private static final String ATTEMPTS = "attempts";
    private static final String SLAVE_SERVER = "slave";
    private static final int DEFAULT_STANDALONE_ATTEMPTS = 10;
    private static final int DEFAULT_DOMAIN_ATTEMPTS = 10;
    private static final int DEFAULT_HTTP = 8080;
    private static final int DEFAULT_MANAGEMENT = 9999;
    private static final int DEFAULT_MANAGEMENT_HTTP = 9990;
    private static final int DEFAULT_MANAGEMENT_HTTPS = 9443;
    private static final int DEFAULT_TIME_BETWEEN_ATTEMPTS = 4;
    private static final int[] DEFAULT_RESPONSE_CODES = new int[]{200};
    public static final String DEFAULT_SERVER_URL = "http://localhost:";
    public static final String DEFAULT_SSL_SERVER_URL = "https://localhost:";
    public static final String OVERRIDE_DEFAULT_TIMEOUT_VARIABLE = "system.timeout.override";
    public static final String FULL_HA = "full-ha";
    public static final String CODE_START_OK_FULL_HA = "JBAS015888";
    private static final HashMap<String, String> portStringMap = new HashMap();
    private static AutomatedInstallData idata;
    private static String currentServerScriptLocation;
    private static boolean currentAdminMode;
    private static boolean isFailMode;
    private static int[] responseCodes;
    private static String pingUrl;
    private static String CONFIG;
    private static volatile String CODE;
    public static boolean SLAVE;
    private static boolean sslEnabled;
    public static String startOfServerURL;

    public static boolean run(AbstractUIProcessHandler handler, String[] args) throws Exception {
        boolean isStarting;
        boolean result = true;
        idata = AutomatedInstallData.getInstance();
        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);
        isFailMode = parser.propertyIsTrue(ONFAIL_JOB);
        boolean bl = isStarting = parser.hasProperty(SERVER_SCRIPT) || parser.hasProperty(POSTINSTALL_SCRIPT);
        if (parser.hasProperty(HOST_CONFIG)) {
            handler.logOutput("[ host-config detected! ]", false);
        }
        ServerManager.setServerCodes();
        ServerManager.setURL(DEFAULT_SERVER_URL);
        ServerManager.setSslEnabled(false);
        if (isStarting) {
            if (!ServerManager.prepareServerForStart(handler, parser)) {
                return false;
            }
            int timeBetweenAttempts = 4;
            String override_server_timeout = idata.getVariable(OVERRIDE_DEFAULT_TIMEOUT_VARIABLE);
            if (override_server_timeout != null && !override_server_timeout.isEmpty()) {
                timeBetweenAttempts = Integer.parseInt(override_server_timeout);
            } else if (parser.hasProperty(TIMEOUT)) {
                timeBetweenAttempts = Integer.parseInt(parser.getStringProperty(TIMEOUT));
            }
            int attempts = parser.hasProperty(ATTEMPTS) ? Integer.parseInt(parser.getStringProperty(ATTEMPTS)) : ServerManager.getDefaultAttempts();
            result = ServerManager.startServer(ServerManager.getServerScriptLocation(), ServerManager.getMode(), ServerManager.getConfig(), ServerManager.getSlave(), ServerManager.isCurrentAdminMode(), timeBetweenAttempts, attempts, handler);
        } else {
            result = ServerManager.callShutdownServer(handler);
        }
        return result;
    }

    private static void setServerCodes() {
        String codeStartOk = idata.getVariable("server.code.start.ok");
        String codeStartError = idata.getVariable("server.code.start.error");
        String codeStopOk = idata.getVariable("server.code.stop.ok");
        String codeProcessFinish = idata.getVariable("server.code.process.finish");
        String codeHostFinish = idata.getVariable("server.code.host.finish");
        String codeSslServer = idata.getVariable("server.code.ssl.server");
        CODE_START_OK = codeStartOk != null ? codeStartOk : "JBAS015874";
        CODE_START_ERROR = codeStartError != null ? codeStartError : "JBAS015875";
        CODE_STOP_OK = codeStopOk != null ? codeStopOk : "JBAS015950";
        CODE_PROCESS_FINISH = codeProcessFinish != null ? codeProcessFinish : "JBAS012015";
        CODE_HOST_FINISH = codeHostFinish != null ? codeHostFinish : "JBAS012010";
        CODE_SSL_SERVER = codeSslServer != null ? codeSslServer : "JBAS015962";
    }

    private static boolean prepareServerForStart(AbstractUIProcessHandler handler, ArgumentParser parser) {
        idata = AutomatedInstallData.getInstance();
        String scriptLocation = ServerManager.extractServerScriptLocation(handler, parser);
        if (scriptLocation == null) {
            ProcessPanelHelper.printToPanel(handler, ServerManager.idata.langpack.getString("ServerManager.noscript"), false);
            return false;
        }
        ServerManager.setServerScriptLocation(scriptLocation);
        String mode = ServerManager.extractMode(handler, parser, scriptLocation);
        String config = ServerManager.extractConfigurations(handler, parser, scriptLocation);
        boolean slave = ServerManager.extractSlave(parser);
        if (mode == null || config == null) {
            ProcessPanelHelper.printToPanel(handler, ServerManager.idata.langpack.getString("ServerManager.wrongarg"), false);
            return false;
        }
        ServerManager.setMode(mode);
        ServerManager.setConfig(config);
        ServerManager.setSlave(slave);
        pingUrl = ServerManager.extractUrl(parser);
        responseCodes = ServerManager.extractResponseCodes(parser);
        return true;
    }

    private static ServerScriptLauncher generateLaunchScript(AbstractUIProcessHandler handler, boolean adminOnly, String mode, String config, boolean slave, String location) {
        ServerScriptLauncher serverScript;
        if (adminOnly) {
            if (mode.contains(STANDALONE)) {
                String configString = config.equals("") ? config : "-" + config;
                serverScript = new ServerScriptLauncher(handler, location, "--admin-only", "--server-config=standalone" + configString + ".xml");
            } else {
                serverScript = !slave ? new ServerScriptLauncher(handler, location, "--admin-only", "--host-config=" + config + ".xml") : new ServerScriptLauncher(handler, location, "--admin-only", "--host-config=" + config + ".xml", "-Djboss.domain.master.address=0");
            }
        } else {
            serverScript = mode.contains(STANDALONE) ? new ServerScriptLauncher(handler, location) : new ServerScriptLauncher(handler, location, "--host-config=" + config + ".xml");
        }
        return serverScript;
    }

    private static boolean startServer(String location, String mode, String config, boolean slave, boolean adminOnly, int timeBetweenAttempts, int attempts, AbstractUIProcessHandler handler) {
        idata = AutomatedInstallData.getInstance();
        String startingServerString = ServerManager.idata.langpack.getString(MSG_STARTING_SERVER);
        String serverStartedString = ServerManager.idata.langpack.getString(MSG_SERVER_STARTED);
        String ServerStartedWithErrors = ServerManager.idata.langpack.getString(MSG_SERVER_STARTED_WITH_ERRORS);
        int port = 8080;
        port = adminOnly ? ServerManager.getManagementPort(mode, config) : ServerManager.getHttpPort(mode, config);
        String url = startOfServerURL + port;
        ServerScriptLauncher serverScript = ServerManager.generateLaunchScript(handler, adminOnly, mode, config, slave, location);
        ServerManager.updateStatus(STARTING, "");
        if (handler != null) {
            handler.logOutput(String.format(startingServerString, ServerManager.getMode(), ServerManager.getConfigString()), false);
        }
        serverScript.runScript();
        if (ServerManager.waitForServerCodeReady(url, timeBetweenAttempts, attempts, handler)) {
            ServerManager.updateStatus(UP, CODE);
            if (handler != null && CODE.equals(CODE_START_ERROR)) {
                handler.logOutput(ServerStartedWithErrors, false);
            } else if (handler != null) {
                handler.logOutput(String.format(serverStartedString, new Object[0]), false);
            }
        } else {
            ServerManager.updateStatus(UNKNOWN, "");
            return false;
        }
        return true;
    }

    private static boolean callShutdownServer(AbstractUIProcessHandler handler) throws Exception {
        if (isFailMode) {
            ProcessPanelHelper.printToPanel(handler, ServerManager.idata.langpack.getString("ServerManager.onfail.check"), false);
        }
        if (ServerManager.isServerDown()) {
            ProcessPanelHelper.printToPanel(handler, ServerManager.idata.langpack.getString("ServerManager.nostart"), false);
            return true;
        }
        if (isFailMode) {
            ProcessPanelHelper.printToPanel(handler, ServerManager.idata.langpack.getString("ServerManager.shutdown"), false);
        }
        return ServerManager.shutdownServer(handler);
    }

    private static boolean shutdownServer(AbstractUIProcessHandler handler) throws CliInitializationException, InterruptedException {
        ModelNode jbossCliOutput;
        idata = AutomatedInstallData.getInstance();
        boolean result = false;
        String servermode = ServerManager.getMode();
        String username = idata.getVariable("postinstall.username");
        String serverShutdownString = ServerManager.idata.langpack.getString("postinstall.processpanel.serverStopped");
        char[] password = idata.getVariable("postinstall.password").toCharArray();
        ServerCommands serverCommands = null;
        int port = 9999;
        if (!ServerManager.getSlave()) {
            port = ServerManager.getManagementPort();
        }
        try {
            serverCommands = ServerCommands.createLocalDomainUsernameSession(username, password, port, ServerManager.getSlave(), null);
        }
        catch (NullPointerException e) {
            ProcessPanelHelper.printToPanel(handler, ServerManager.idata.langpack.getString("ServerManager.alreadyoff"), false);
        }
        ServerCommandsHelper.connectContext(handler, serverCommands);
        if (servermode.contains(DOMAIN)) {
            Debug.log("Attempting to shut down domain at port " + port);
            jbossCliOutput = serverCommands.shutdownDomainHost();
            result = Operations.isSuccessfulOutcome(jbossCliOutput);
        } else if (servermode.contains(STANDALONE)) {
            Debug.log("Attempting to shut down standalone at port " + port);
            jbossCliOutput = serverCommands.shutdownHost();
            result = Operations.isSuccessfulOutcome(jbossCliOutput);
        } else {
            Debug.log("No running server info found. Aborting shutdown.");
            jbossCliOutput = null;
        }
        if (serverCommands != null) {
            serverCommands.terminateSession();
        }
        long startTime = System.currentTimeMillis();
        while (!ServerManager.isServerDown() && result && System.currentTimeMillis() - startTime <= 10000L) {
        }
        if (!result) {
            serverShutdownString = jbossCliOutput.asString();
        }
        if (handler != null) {
            ProcessPanelHelper.printToPanel(handler, serverShutdownString, !result);
        }
        ServerManager.updateStatus(DOWN, CODE_STOP_OK);
        return result;
    }

    private static String extractServerScriptLocation(AbstractUIProcessHandler handler, ArgumentParser parser) {
        String serverLocation = null;
        if (parser.hasProperty(SERVER_SCRIPT)) {
            serverLocation = parser.getStringProperty(SERVER_SCRIPT);
            ServerManager.setCurrentAdminMode(false);
        } else if (parser.hasProperty(POSTINSTALL_SCRIPT)) {
            serverLocation = parser.getStringProperty(POSTINSTALL_SCRIPT);
            ServerManager.setCurrentAdminMode(true);
        } else {
            ProcessPanelHelper.printToPanel(handler, ServerManager.idata.langpack.getString("ServerManager.invalidargs"), false);
        }
        return serverLocation;
    }

    private static String extractMode(AbstractUIProcessHandler handler, ArgumentParser parser, String scriptLocation) {
        String mode = null;
        String scriptName = new File(scriptLocation).getName();
        if (scriptName.contains(DOMAIN)) {
            mode = DOMAIN;
        } else if (scriptName.contains(STANDALONE)) {
            mode = STANDALONE;
        }
        return mode;
    }

    private static String extractConfigurations(AbstractUIProcessHandler handler, ArgumentParser parser, String scriptLocation) {
        String config = null;
        String scriptName = new File(scriptLocation).getName();
        if (scriptName.contains(DOMAIN)) {
            if (parser.hasProperty(HOST_CONFIG)) {
                config = parser.getStringProperty(HOST_CONFIG);
                if (handler != null) {
                    ProcessPanelHelper.printToPanel(handler, "[ host-config detected: " + config + "]", false);
                }
            } else {
                config = "host";
            }
        } else if (scriptName.contains(STANDALONE)) {
            config = parser.hasProperty(STANDALONE_CONFIG) ? parser.getStringProperty(STANDALONE_CONFIG) : "";
        }
        return config;
    }

    private static boolean extractSlave(ArgumentParser parser) {
        boolean slave = false;
        if (parser.hasProperty(SLAVE_SERVER) && parser.getStringProperty(SLAVE_SERVER).toLowerCase().equals("true")) {
            slave = true;
        }
        return slave;
    }

    private static String extractUrl(ArgumentParser parser) {
        String url = null;
        if (parser.hasProperty("url-ext")) {
            url = parser.getStringProperty("url-ext");
        }
        return url;
    }

    private static int[] extractResponseCodes(ArgumentParser parser) {
        int[] codes = null;
        if (parser.hasProperty("url-resp")) {
            codes = new int[]{200, Integer.parseInt(parser.getStringProperty("url-resp"))};
        }
        return codes;
    }

    public static String getStatus() {
        return STATUS;
    }

    public static String getMode() {
        return MODE;
    }

    public static void setMode(String mode) {
        MODE = mode;
    }

    public static String getConfig() {
        return CONFIG;
    }

    public static boolean getSlave() {
        return SLAVE;
    }

    public static String getConfigString() {
        String config = ServerManager.getConfig();
        if (ServerManager.getMode().contains(STANDALONE)) {
            return (config.isEmpty() ? config : "-" + config) + ".xml";
        }
        return ServerManager.getConfig() + ".xml";
    }

    public static String getConfigPath() {
        String fileName = ServerManager.getConfigString();
        if (fileName.contains("host")) {
            return "domain/configuration/" + fileName;
        }
        return "standalone/configuration/standalone" + fileName;
    }

    public static boolean isServerUp() {
        return STATUS.equalsIgnoreCase(UP);
    }

    public static boolean isServerStarting() {
        return STATUS.equalsIgnoreCase(STARTING);
    }

    public static boolean isServerDown() {
        return STATUS.equalsIgnoreCase(DOWN);
    }

    public static void setServerUp() {
        STATUS = UP;
    }

    public static String getServerCode() {
        return CODE;
    }

    public static void setServerCode(String code) {
        CODE = code;
    }

    public static void setServerDown() {
        STATUS = DOWN;
    }

    public static boolean isCurrentAdminMode() {
        return currentAdminMode;
    }

    public static void setCurrentAdminMode(boolean currentAdminMode) {
        ServerManager.currentAdminMode = currentAdminMode;
    }

    public static String getServerScriptLocation() {
        return currentServerScriptLocation;
    }

    public static void setServerScriptLocation(String location) {
        currentServerScriptLocation = location;
    }

    private static boolean isServerCodeReady() {
        return CODE.contains(CODE_START_OK) || CODE.contains(CODE_START_ERROR) || CODE.contains(CODE_START_OK_FULL_HA);
    }

    public static int getHttpPort() {
        return ServerManager.getPort(8080, "http");
    }

    public static void setURL(String url) {
        startOfServerURL = url;
    }

    public static String getURL() {
        return startOfServerURL;
    }

    public static int getManagementPort() {
        AutomatedInstallData adata = AutomatedInstallData.getInstance();
        if (adata.getPackage("eap") == null) {
            return PortReader.getManagementPort(ServerManager.getConfigPath());
        }
        return 9990;
    }

    public static int getManagementConsolePort() {
        String portName = "management-http";
        int defaultPortNumber = 9990;
        if (ServerManager.isSslEnabled()) {
            portName = "management-https";
            defaultPortNumber = 9443;
        }
        return ServerManager.getPort(defaultPortNumber, portName);
    }

    private static boolean waitForServerCodeReady(String url, int timeout, int attemptLimit, AbstractUIProcessHandler handler) {
        String checkingServerString = ServerManager.idata.langpack.getString("postinstall.processpanel.checkingServer");
        String serverNotStartedString = ServerManager.idata.langpack.getString("postinstall.processpanel.serverNotStarted");
        String serverCodeNotDetectedString = ServerManager.idata.langpack.getString("postinstall.processpanel.serverCodeNotDetected");
        int currentAttempt = 0;
        int totalTime = timeout * attemptLimit;
        String timeUnit = "seconds";
        if (totalTime > 60) {
            totalTime /= 60;
            timeUnit = "minutes";
        }
        if (handler != null) {
            ProcessPanelHelper.printToPanel(handler, String.format(checkingServerString, totalTime, timeUnit), false);
        }
        while (!ServerManager.isServerCodeReady()) {
            if (handler != null) {
                ProcessPanelHelper.printToPanel(handler, ".", false);
            }
            try {
                Thread.sleep(timeout * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (++currentAttempt <= attemptLimit) continue;
            ProcessPanelHelper.printToPanel(handler, String.format(serverCodeNotDetectedString, new Object[0]), true);
            if (ServerManager.isLinkAlive(url)) {
                return true;
            }
            if (handler != null) {
                ProcessPanelHelper.printToPanel(handler, String.format(serverNotStartedString, attemptLimit + 1), true);
            }
            ServerManager.updateStatus(UNKNOWN, "");
            return false;
        }
        return true;
    }

    private static int getHttpPort(String mode, String config) {
        return ServerManager.getPort(mode, config, 8080, "http");
    }

    private static int getManagementPort(String mode, String config) {
        return ServerManager.getPort(mode, config, 9999, "management-native");
    }

    private static int getPort(int defaultPort, String portName) {
        String serverMode = ServerManager.getMode();
        String standaloneConfig = ServerManager.getConfig();
        return ServerManager.getPort(serverMode, standaloneConfig, defaultPort, portName);
    }

    private static String getPortPrefix(String serverMode, String standaloneConfig) {
        String prefix = standaloneConfig.equals("") ? serverMode : (serverMode.contains(STANDALONE) ? serverMode + "." + portStringMap.get(standaloneConfig) : serverMode);
        return prefix;
    }

    private static int getPort(String serverMode, String standaloneConfig, int defaultPort, String portName) {
        int offset;
        String portString;
        String prefix;
        String var;
        idata = AutomatedInstallData.getInstance();
        String val = idata.getVariable(var = (prefix = ServerManager.getPortPrefix(serverMode, standaloneConfig)) + "." + portName);
        int port = val != null ? ((portString = idata.getVariable(prefix + "." + portName)).contains("$") ? Integer.parseInt(portString.substring(portString.indexOf(58) + 1, portString.length() - 1)) : Integer.parseInt(portString)) : defaultPort;
        int n = offset = idata.getVariable("domain.port-offset") != null ? Integer.parseInt(idata.getVariable("domain.port-offset")) : 0;
        if (serverMode.contains(DOMAIN) && (portName.contains("management-native") || portName.contains("management-http"))) {
            offset = 0;
        }
        return port + offset;
    }

    private static boolean isLinkAlive(String URLName) {
        String url = pingUrl == null ? URLName : URLName + pingUrl;
        int[] ports = responseCodes == null ? DEFAULT_RESPONSE_CODES : responseCodes;
        return ServerManager.isLinkAlive(url, ports);
    }

    public static boolean isLinkAlive(String URLName, int[] goodcodes) {
        try {
            URL url = new URL(URLName);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.connect();
            Debug.log("Server Response Code: " + urlConn.getResponseCode());
            for (int code : goodcodes) {
                if (urlConn.getResponseCode() != code) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            Debug.log(e.getMessage());
            return false;
        }
    }

    private static boolean pingServer(String url, int timeBetweenAttempts, int attemptLimit, AbstractUIProcessHandler handler) {
        String checkingServerString = ServerManager.idata.langpack.getString("postinstall.processpanel.checkingServer");
        String serverNotStartedString = ServerManager.idata.langpack.getString("postinstall.processpanel.serverNotStarted");
        int currentAttempt = 0;
        Debug.log(ServerManager.getServerStatusString());
        while (!ServerManager.isLinkAlive(url) && !ServerManager.isServerCodeReady()) {
            if (handler != null) {
                ProcessPanelHelper.printToPanel(handler, String.format(checkingServerString, currentAttempt + 1, attemptLimit + 1), false);
            }
            try {
                Thread.sleep(timeBetweenAttempts * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (++currentAttempt <= attemptLimit) continue;
            if (handler != null) {
                ProcessPanelHelper.printToPanel(handler, String.format(serverNotStartedString, attemptLimit + 1), true);
            }
            return false;
        }
        return true;
    }

    private static String getServerStatusString() {
        return "Status: " + STATUS + "\nMode: " + MODE + "\nConfig: " + CONFIG;
    }

    private static int getDefaultAttempts() {
        return ServerManager.getMode().contains(STANDALONE) ? 10 : 10;
    }

    private static void updateStatus(String status, String code) {
        STATUS = status;
        CODE = code;
        Debug.log("Recording Server Status:" + ServerManager.getServerStatusString());
    }

    public static void setConfig(String config) {
        CONFIG = config;
    }

    public static void setSlave(boolean slave) {
        SLAVE = slave;
    }

    public static void setSslEnabled(boolean sslEnabled) {
        ServerManager.sslEnabled = sslEnabled;
    }

    public static boolean isSslEnabled() {
        return sslEnabled;
    }

    @Override
    public void beforePacks(AutomatedInstallData idata, Integer x, AbstractUIProgressHandler handler) throws Exception {
        Debug.log("Registering ServerManager for Cleanup.");
        Housekeeper.getInstance().registerForCleanup(this);
    }

    @Override
    public void cleanUp() {
        idata = AutomatedInstallData.getInstance();
        String aborted = idata.getVariable("install.aborted");
        Debug.log("Housekeeper: Running Server Manager Clean Up.");
        if (aborted == null && !Boolean.parseBoolean(aborted) || ServerManager.isServerDown()) {
            Debug.log("Housekeeper: Server Not Up.");
            PostInstallUserHelper.removePostInstallUser();
            return;
        }
        try {
            Debug.log("Housekeeper: Server Up. Shutting Down.");
            ServerManager.shutdownServer(null);
        }
        catch (Exception e) {
            Debug.log("Shutdown Server Exception: " + e.getMessage());
        }
    }

    static {
        portStringMap.put("", "");
        portStringMap.put("ha", "h");
        portStringMap.put("full", "f");
        portStringMap.put(FULL_HA, "fa");
        currentServerScriptLocation = "";
        currentAdminMode = false;
        isFailMode = false;
        responseCodes = null;
        pingUrl = null;
        CONFIG = "";
        CODE = "";
        SLAVE = false;
        sslEnabled = false;
        startOfServerURL = DEFAULT_SERVER_URL;
    }
}

