/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ascontroller;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import com.redhat.installer.asconfiguration.ascontroller.ServerManager;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class ServerScriptLauncher {
    private static final int SPLASH_SCREEN_LENGTH = 11;
    private ProcessBuilder builder;
    private Process p;
    private BufferedReader reader;
    private BufferedWriter writer;
    private static AbstractUIProcessHandler mHandler;
    private AutomatedInstallData idata;

    ServerScriptLauncher(String ... command) {
        this.builder = new ProcessBuilder(command);
        ProcessPanelHelper.adjustJbossHome(this.builder);
        mHandler = null;
    }

    ServerScriptLauncher(AbstractUIProcessHandler handler, String ... command) {
        this.idata = AutomatedInstallData.getInstance();
        this.builder = new ProcessBuilder(command);
        this.builder.redirectErrorStream(true);
        ProcessPanelHelper.adjustJbossHome(this.builder);
        ProcessPanelHelper.printToPanel(handler, String.format(this.idata.langpack.getString("ProcessPanelHelper.jbosshome.adjusted"), this.builder.environment().get("JBOSS_HOME")), false);
        mHandler = handler;
    }

    public static String extractCode(String line) {
        String code = "";
        if (line.contains(ServerManager.CODE_START_OK)) {
            code = ServerManager.CODE_START_OK;
        } else if (line.contains(ServerManager.CODE_START_ERROR)) {
            code = ServerManager.CODE_START_ERROR;
        } else if (line.contains("JBAS015888") && ServerManager.getConfig().equals("full-ha")) {
            code = "JBAS015888";
        }
        return code;
    }

    public static String extractSSLCode(String line) {
        String code = "";
        if (line.contains(ServerManager.CODE_SSL_SERVER)) {
            code = ServerManager.CODE_SSL_SERVER;
        }
        return code;
    }

    public static String extractEndCode(String line) {
        String code = "";
        if (line.contains(ServerManager.CODE_STOP_OK)) {
            code = ServerManager.CODE_STOP_OK;
        }
        return code;
    }

    public void runScript() {
        try {
            this.p = this.builder.start();
            this.reader = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.p.getOutputStream()));
            this.writer.newLine();
            this.writer.flush();
            Thread b = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        boolean foundCode = false;
                        boolean serverNotReady = true;
                        int counter = 0;
                        while ((line = ServerScriptLauncher.this.reader.readLine()) != null) {
                            String endCode;
                            String sslCode;
                            String code = ServerScriptLauncher.extractCode(line);
                            if (!code.isEmpty() && !foundCode) {
                                ServerManager.setServerCode(code);
                                ProcessPanelHelper.printToPanel(mHandler, String.format(((ServerScriptLauncher)ServerScriptLauncher.this).idata.langpack.getString("ProcessPanelHelper.servercode.detected"), code), false);
                                serverNotReady = false;
                                foundCode = true;
                            }
                            if (!(sslCode = ServerScriptLauncher.extractSSLCode(line)).isEmpty()) {
                                ServerManager.setSslEnabled(true);
                                ServerManager.setURL("https://localhost:");
                            }
                            if (!(endCode = ServerScriptLauncher.extractEndCode(line)).isEmpty()) {
                                ServerManager.setServerDown();
                                serverNotReady = false;
                            }
                            if (line.lastIndexOf(27) > -1) {
                                line = line.substring(line.lastIndexOf(27), line.length());
                                line = line.substring(line.indexOf(109) + 1, line.length());
                            }
                            if (serverNotReady) {
                                if (counter > 11 && line.isEmpty()) continue;
                                ProcessPanelHelper.printToPanel(mHandler, line, false);
                            }
                            ++counter;
                        }
                    }
                    catch (IOException e) {
                        Debug.log(e.getMessage());
                    }
                }
            });
            b.setDaemon(true);
            b.start();
            b.join(5000L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

