/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.datasource.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.jdbc.constant.JBossJDBCConstants;
import com.redhat.installer.gui.dynamic.DynamicValidator;
import java.util.regex.Pattern;

public class DataSourcePropertyValidator
implements DynamicValidator {
    AutomatedInstallData idata = AutomatedInstallData.getInstance();
    private String errorMsg;
    private String badProperty;
    private String badValue;

    @Override
    public boolean validateData(String property, String value) {
        if (!this.validateProperty(property, value)) {
            this.badProperty = property;
            this.badValue = value;
            return false;
        }
        return true;
    }

    public boolean validateProperty(String property, String value) {
        Pattern equalPattern = Pattern.compile("^.+=.+$");
        Pattern propPattern = Pattern.compile("^((\\\"([^\\\"]+)\\\")|([^,=\\{\\}\\[\\]]+))+$");
        Pattern valuePattern = Pattern.compile("^((\\\"([^\\\"]+)\\\")|([^,=\\{\\}\\[\\]]+))+$");
        if (property.equals("") || value.equals("")) {
            this.errorMsg = this.idata.langpack.getString("JBossDatasourceConfigPanel.xa.error.wrongFormat");
            return false;
        }
        if (!propPattern.matcher(property).matches()) {
            this.errorMsg = this.idata.langpack.getString("JBossDatasourceConfigPanel.xa.error.invalidChars");
            return false;
        }
        if (!valuePattern.matcher(value).matches()) {
            this.errorMsg = this.idata.langpack.getString("JBossDatasourceConfigPanel.xa.error.invalidChars");
            return false;
        }
        return true;
    }

    public boolean noVendorPropertyMatch(String propertyName) {
        return !JBossJDBCConstants.vendorPropertyMap.containsKey(propertyName);
    }

    @Override
    public String getErrorMessageId() {
        return String.format(this.errorMsg, this.badProperty, this.badValue);
    }

    @Override
    public String getWarningMessageId() {
        return this.idata.langpack.getString("JBossDatasourceConfigPanel.warning.xaProperty");
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

