/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.datasource.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.UserInputPanel;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.PasswordEqualityValidator;
import com.redhat.installer.asconfiguration.jdbc.constant.JBossJDBCConstants;
import com.redhat.installer.asconfiguration.jdbc.validator.JDBCConnectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;

public class DatasourceConnectionValidator
implements Validator,
DataValidator {
    private String message;
    private String warning;
    private AutomatedInstallData idata;

    private boolean isSecurityDomain(AutomatedInstallData idata) {
        return idata.getVariable("JBossDatasourceConfigPanel.securitytype.value").equals("Security-domain");
    }

    @Override
    public Validator.Status validate(ProcessingClient client) {
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        this.idata = AutomatedInstallData.getInstance();
        if (!this.validatePasswordField(client)) {
            return failureStatus;
        }
        AutomatedInstallData adata = AutomatedInstallData.getInstance();
        String driverClassName = adata.getVariable("jdbc.driver.name");
        String username = adata.getVariable("jdbc.datasource.username");
        String password = adata.getVariable("jdbc.datasource.password");
        String connectionUrl = adata.getVariable("jdbc.datasource.connectionurl");
        if (driverClassName != null) {
            Object[] jarPaths = JDBCConnectionUtils.readIdataForJarPaths("jdbc.driver.jar").toArray();
            Class<?> driverClass = JDBCConnectionUtils.findDriverClass(JBossJDBCConstants.classnameMap.get(driverClassName), JDBCConnectionUtils.convertToUrlArray(jarPaths));
            if (this.isSecurityDomain(adata)) {
                this.setWarningMessageId("DatabaseLoggingConnectionValidator.connection.failed");
                return failureStatus;
            }
            Driver driverInstance = null;
            try {
                driverInstance = (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            Object jdbcConnection = JDBCConnectionUtils.getDatabaseConnection(driverInstance, username, password, connectionUrl);
            if (jdbcConnection != null) {
                if (jdbcConnection.getClass().equals(String.class)) {
                    this.setWarningMessageId("DatabaseLoggingConnectionValidator.connection.failed");
                    return failureStatus;
                }
                try {
                    ((Connection)jdbcConnection).close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return Validator.Status.OK;
            }
            this.setWarningMessageId("DatabaseLoggingConnectionValidator.connection.failed");
            return failureStatus;
        }
        return failureStatus;
    }

    private boolean validatePasswordField(ProcessingClient client) {
        UserInputPanel uip;
        PasswordGroup processingClient;
        PasswordEqualityValidator pev;
        PasswordGroup toTest = (PasswordGroup)client;
        if (toTest.getGroupName() != null && !toTest.getGroupName().isEmpty() && (pev = new PasswordEqualityValidator()).validate(processingClient = (uip = (UserInputPanel)this.idata.panels.get(this.idata.curPanelNumber)).getPasswordGroups().get(toTest.getGroupName())) != Validator.Status.OK) {
            this.setWarningMessageId("username.no.match.password");
            this.message = AutomatedInstallData.getInstance().langpack.getString(this.warning);
            return false;
        }
        return true;
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return this.warning;
    }

    @Override
    public String getWarningMessageId() {
        return this.warning;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }

    public void setWarningMessageId(String id) {
        this.warning = id;
    }
}

