/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.javaopts;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaOptsValidator
implements Validator {
    private boolean success;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Validator.Status validate(ProcessingClient client) {
        String input;
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        if ((input = client.getText()).isEmpty()) {
            return Validator.Status.OK;
        }
        Pattern badArgsPattern = Pattern.compile("\\s*-version\\s+|\\s*-X\\s+|\\s*-D\\s+|\\s+[^-]+\\s+|^\\s*[^-]+\\s+|suspend=y");
        Matcher m = badArgsPattern.matcher(input);
        if (m.find()) {
            return failureStatus;
        }
        String[] javaopts = input.split(" ");
        String pathToJava = System.getProperty("java.home");
        String[] command = new String[1 + javaopts.length];
        int counter = 0;
        command[counter] = pathToJava + "/bin/java";
        for (String option : javaopts) {
            command[++counter] = option;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process p = null;
        BufferedReader reader = null;
        try {
            String line;
            p = processBuilder.start();
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            this.success = true;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("Error")) continue;
                this.success = false;
                break;
            }
            p.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Validator.Status validationResult = this.success ? Validator.Status.OK : failureStatus;
        return validationResult;
    }
}

