/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.jdbc.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.redhat.installer.asconfiguration.jdbc.constant.JBossJDBCConstants;
import com.redhat.installer.asconfiguration.jdbc.validator.JDBCConnectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public abstract class DatabaseConnectionValidator
implements DataValidator,
Validator {
    protected AutomatedInstallData idata;
    protected String errorMessageId;
    protected String formattedMessage;

    protected abstract String getDriverName();

    protected abstract Object getDatabaseConnection();

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        this.idata = idata;
        if (!this.isDriverNameValid()) {
            this.setErrorMessageId("DatabaseConnectionValidator.missing.using.h2");
            this.setFormattedMessage(idata.langpack.getString(this.getErrorMessageId()));
            return DataValidator.Status.ERROR;
        }
        if (!this.connectToDatabase()) {
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    protected boolean connectToDatabase() {
        Object connection = this.getDatabaseConnection();
        if (connection != null) {
            if (connection.getClass().equals(String.class)) {
                this.setErrorMessageId("DatabaseConnectionValidator.connection.failed");
                this.setFormattedMessage(this.idata.langpack.getString(this.getErrorMessageId()));
                return false;
            }
            try {
                ((Connection)connection).close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.setErrorMessageId("DatabaseConnectionValidator.connection.success");
            this.setFormattedMessage(this.idata.langpack.getString(this.getErrorMessageId()));
            return true;
        }
        return false;
    }

    protected Driver getDriverInstance() {
        Driver driver;
        Class driverClass = this.findDriverClass();
        if (driverClass == null) {
            return null;
        }
        try {
            driver = (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        return driver;
    }

    private Class findDriverClass() {
        Set<String> jarPaths = this.loadJarPaths();
        String driverClassName = JBossJDBCConstants.classnameMap.get(this.getDriverName());
        Class<?> returnClass = null;
        if (jarPaths.size() > 0) {
            returnClass = JDBCConnectionUtils.findDriverClass(driverClassName, JDBCConnectionUtils.convertToUrlArray(jarPaths.toArray()));
        }
        return returnClass;
    }

    private Set<String> loadJarPaths() {
        String driverPath;
        HashSet<String> jars = new HashSet<String>();
        int i = 1;
        while ((driverPath = this.idata.getVariable("jdbc.driver.jar-" + i + "-path")) != null) {
            jars.add(driverPath);
            ++i;
        }
        return jars;
    }

    protected boolean isDriverNameValid() {
        String driverName = this.getDriverName();
        if (driverName == null) {
            this.setErrorMessageId("DatabaseConnectionValidator.missing.driver.name");
            return false;
        }
        return !driverName.equals("h2");
    }

    @Override
    public Validator.Status validate(ProcessingClient client) {
        DataValidator.Status status = this.validateData(AutomatedInstallData.getInstance());
        Validator.Status validationResult = status == DataValidator.Status.OK ? Validator.Status.OK : Validator.Status.WARNING;
        return validationResult;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return this.errorMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public String getFormattedMessage() {
        return null;
    }

    public void setErrorMessageId(String errorMessageId) {
        this.errorMessageId = errorMessageId;
    }

    public void setFormattedMessage(String formattedMessage) {
        this.formattedMessage = formattedMessage;
    }
}

