/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.jdbc.validator;

import com.redhat.installer.asconfiguration.jdbc.validator.DatabaseConnectionValidator;
import com.redhat.installer.asconfiguration.jdbc.validator.JDBCConnectionUtils;
import java.sql.Driver;

public class DatabaseLoggingConnectionValidator
extends DatabaseConnectionValidator {
    @Override
    protected Object getDatabaseConnection() {
        Driver driver = this.getDriverInstance();
        String dbUser = this.idata.getVariable("dblogging.username");
        String dbPassword = this.idata.getVariable("dblogging.password");
        String dbUrl = this.idata.getVariable("dblogging.url");
        if (driver == null) {
            this.setErrorMessageId("DatabaseLoggingConnectionValidator.driver.instantiation.failed");
            this.setFormattedMessage(String.format(this.idata.langpack.getString(this.getErrorMessageId()), new Object[0]));
            return null;
        }
        return JDBCConnectionUtils.getDatabaseConnection(driver, dbUser, dbPassword, dbUrl);
    }

    @Override
    protected String getDriverName() {
        String driverName = this.idata.getVariable("dblogging.driver");
        if (driverName.equals("installed")) {
            driverName = this.idata.getVariable("jdbc.driver.name");
        }
        return driverName;
    }
}

