/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.jdbc.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class JDBCConnectionUtils {
    private static final String excluded = "<>\"{}|\\^`";
    private static final String HEX_DIGITS = "0123456789abcdef";
    private static List<String> supportedProtocols = new ArrayList<String>();
    private static String utf8;

    public static URL[] convertToUrlArray(Object[] jars) {
        URL[] jarUrls = new URL[jars.length];
        for (int i = 0; i < jarUrls.length; ++i) {
            try {
                String jar = (String)jars[i];
                jar = JDBCConnectionUtils.escapeDisallowedChars(jar);
                URI jarUri = new URI(jar);
                if (supportedProtocols.contains(jarUri.getScheme())) {
                    jarUrls[i] = new URI(jar).toURL();
                    continue;
                }
                jarUrls[i] = new URI("file:///" + jar).toURL();
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                continue;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return jarUrls;
    }

    public static Object getDatabaseConnection(Driver driver, String username, String password, String url) {
        Properties dbInfo = new Properties();
        dbInfo.put("user", username);
        dbInfo.put("password", password);
        Connection conn = null;
        try {
            conn = driver.connect(url, dbInfo);
        }
        catch (Exception e) {
            String error = AutomatedInstallData.getInstance().langpack.getString("JBossJDBCDriverSetupPanel.connection.error") + "\n" + e;
            return error;
        }
        return conn;
    }

    public static List<String> readIdataForJarPaths(String variablePrefix) {
        String path;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        ArrayList<String> jarPathsList = new ArrayList<String>();
        String dashedVariablePrefix = variablePrefix + "-";
        String variableSuffix = "-path";
        int counter = 1;
        while ((path = idata.getVariable(dashedVariablePrefix + counter + variableSuffix)) != null) {
            jarPathsList.add(path);
            ++counter;
        }
        return jarPathsList;
    }

    public static Class<?> findDriverClass(String driverClassName, URL ... jarUrls) {
        if (driverClassName == null) {
            return null;
        }
        URLClassLoader loader = null;
        Class<?> driverClass = null;
        try {
            loader = URLClassLoader.newInstance(jarUrls);
            driverClass = loader.loadClass(driverClassName);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return driverClass;
    }

    public static String escapeDisallowedChars(String s) {
        StringBuffer buf = null;
        int len = s.length();
        int done = 0;
        while (true) {
            byte[] bytes;
            int i = done;
            while (true) {
                if (i == len) {
                    if (done != 0) break;
                    return s;
                }
                if (JDBCConnectionUtils.isExcluded(s.charAt(i))) break;
                ++i;
            }
            if (buf == null) {
                buf = new StringBuffer();
            }
            if (i > done) {
                buf.append(s.substring(done, i));
                done = i;
            }
            if (i == len) break;
            ++i;
            while (i < len && JDBCConnectionUtils.isExcluded(s.charAt(i))) {
                ++i;
            }
            String tem = s.substring(done, i);
            try {
                bytes = tem.getBytes(utf8);
            }
            catch (UnsupportedEncodingException e) {
                utf8 = "UTF8";
                try {
                    bytes = tem.getBytes(utf8);
                }
                catch (UnsupportedEncodingException e2) {
                    return s;
                }
            }
            for (int j = 0; j < bytes.length; ++j) {
                buf.append('%');
                buf.append(HEX_DIGITS.charAt((bytes[j] & 0xFF) >> 4));
                buf.append(HEX_DIGITS.charAt(bytes[j] & 0xF));
            }
            done = i;
        }
        return buf.toString();
    }

    private static boolean isExcluded(char c) {
        return c <= ' ' || c >= '\u007f' || excluded.indexOf(c) >= 0;
    }

    static {
        supportedProtocols.add("http");
        supportedProtocols.add("https");
        supportedProtocols.add("ftp");
        supportedProtocols.add("file");
        supportedProtocols.add("jar");
        utf8 = "UTF-8";
    }
}

