/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.jdbc.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.MultiMessageValidator;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.redhat.installer.asconfiguration.utils.JarUtils;
import java.util.List;
import java.util.Stack;

public class JDBCJarExistsValidator
implements Validator,
MultiMessageValidator {
    private String formatedMessage;

    @Override
    public Validator.Status validate(ProcessingClient client) {
        AutomatedInstallData adata = AutomatedInstallData.getInstance();
        Stack stack = (Stack)adata.getAttribute("dynamic.component.values");
        if (stack != null) {
            Validator.Status failureStatus = Validator.Status.ERROR;
            if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
                failureStatus = Validator.Status.WARNING;
            }
            for (int i = 0; i < stack.size(); ++i) {
                String jarPath = (String)((List)stack.get(i)).get(0);
                switch (JarUtils.verifyJarPath(jarPath)) {
                    case 1: {
                        this.setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path.error"), jarPath));
                        return failureStatus;
                    }
                    case 2: {
                        this.setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path.notzip"), jarPath));
                        return failureStatus;
                    }
                    case 3: {
                        this.setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path.emptyzip"), jarPath));
                        return failureStatus;
                    }
                    case 4: {
                        this.setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path.remote.error"), jarPath));
                        return failureStatus;
                    }
                    case 5: {
                        this.setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path.exception.error"), jarPath));
                        return failureStatus;
                    }
                }
            }
        }
        return Validator.Status.OK;
    }

    public void setFormattedMessage(String message) {
        this.formatedMessage = message;
    }

    @Override
    public String getMessage() {
        return this.formatedMessage;
    }
}

