/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.jdbc.validator;

import com.redhat.installer.asconfiguration.jdbc.validator.DatabaseConnectionValidator;
import com.redhat.installer.asconfiguration.jdbc.validator.JDBCConnectionUtils;
import java.sql.Driver;

public class QuartzConnectionValidator
extends DatabaseConnectionValidator {
    @Override
    protected Object getDatabaseConnection() {
        Driver driver = this.getDriverInstance();
        String quartzUser = this.idata.getVariable("quartz.db.username");
        String quartzPassword = this.idata.getVariable("quartz.db.password");
        String quartzUrl = this.idata.getVariable("quartz.db.url");
        if (driver == null) {
            this.setErrorMessageId("QuartzConnectionValidator.driver.instantiation.failed");
            this.setFormattedMessage(String.format(this.idata.langpack.getString(this.getErrorMessageId()), new Object[0]));
            return null;
        }
        return JDBCConnectionUtils.getDatabaseConnection(driver, quartzUser, quartzPassword, quartzUrl);
    }

    @Override
    protected String getDriverName() {
        return this.idata.getVariable("jdbc.driver.name");
    }

    @Override
    protected boolean isDriverNameValid() {
        return true;
    }
}

