/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.jdbc.validator;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.asconfiguration.jdbc.constant.JBossJDBCConstants;
import com.redhat.installer.asconfiguration.jdbc.validator.JDBCConnectionUtils;
import com.redhat.installer.asconfiguration.utils.JarUtils;
import java.util.HashSet;

public class VerifyJDBCJarsValidator
implements DataValidator {
    private String formatedMessage;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        Object[] jarPaths;
        HashSet<String> jarPathSet = new HashSet<String>();
        for (String key : adata.getVariables().stringPropertyNames()) {
            if (!key.matches("^jdbc.driver.jar-[0-9]+-path$")) continue;
            adata.getVariable(key);
            jarPathSet.add(adata.getVariable(key));
        }
        if (jarPathSet.isEmpty()) {
            this.setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path.nopaths"), new Object[0]));
            return DataValidator.Status.ERROR;
        }
        for (String jarPath : jarPathSet) {
            if (this.validJarPath(jarPath, adata.langpack)) continue;
            return DataValidator.Status.ERROR;
        }
        String driverName = adata.getVariable("jdbc.driver.vendor.name");
        if (!this.validJDBCDriver(driverName, jarPaths = jarPathSet.toArray())) {
            this.setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path.nodriver"), this.getJDBCClassName(driverName)));
            return DataValidator.Status.WARNING;
        }
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.formatedMessage;
    }

    public void setFormattedMessage(String message) {
        this.formatedMessage = message;
    }

    private boolean validJarPath(String jarPath, LocaleDatabase langpack) {
        String safeDisplayPath;
        if (jarPath.length() > 95) {
            int startIndex = jarPath.length() - 80;
            safeDisplayPath = "..." + jarPath.substring(startIndex);
        } else {
            safeDisplayPath = jarPath;
        }
        switch (JarUtils.verifyJarPath(jarPath)) {
            case 0: {
                break;
            }
            case 1: {
                this.setFormattedMessage(String.format(langpack.getString("JBossJDBCDriverSetupPanel.path.error"), safeDisplayPath));
                return false;
            }
            case 2: {
                this.setFormattedMessage(String.format(langpack.getString("JBossJDBCDriverSetupPanel.path.notzip"), safeDisplayPath));
                return false;
            }
            case 3: {
                this.setFormattedMessage(String.format(langpack.getString("JBossJDBCDriverSetupPanel.path.emptyzip"), safeDisplayPath));
                return false;
            }
            case 4: {
                this.setFormattedMessage(String.format(langpack.getString("JBossJDBCDriverSetupPanel.path.remote.error"), safeDisplayPath));
                return false;
            }
            case 5: {
                this.setFormattedMessage(String.format(langpack.getString("JBossJDBCDriverSetupPanel.path.exception.error"), safeDisplayPath));
                return false;
            }
        }
        return true;
    }

    private boolean validJDBCDriver(String jdbcName, Object[] jarPaths) {
        Class<?> driverClass = JDBCConnectionUtils.findDriverClass(JBossJDBCConstants.classnameMap.get(jdbcName), JDBCConnectionUtils.convertToUrlArray(jarPaths));
        return driverClass != null;
    }

    private String getJDBCClassName(String jdbcName) {
        if (jdbcName.equals("ibmdb2")) {
            return JBossJDBCConstants.ibmDriverClassCheck;
        }
        if (jdbcName.equals("mysql")) {
            return JBossJDBCConstants.mysqlDriverClassCheck;
        }
        if (jdbcName.equals("sybase")) {
            return JBossJDBCConstants.sybaseDriverClassCheck;
        }
        if (jdbcName.equals("postgresql")) {
            return JBossJDBCConstants.postgresqlDriverClassCheck;
        }
        if (jdbcName.equals("sqlserver")) {
            return JBossJDBCConstants.microsoftDriverClassCheck;
        }
        if (jdbcName.equals("oracle")) {
            return JBossJDBCConstants.oracleDriverClassCheck;
        }
        if (jdbcName.equals("mariadb")) {
            return JBossJDBCConstants.mariadbDriverClassCheck;
        }
        return null;
    }
}

