/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.jsf;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.MultiMessageValidator;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.redhat.installer.asconfiguration.utils.JarUtils;

public class JsfJarsExistsValidator
implements Validator,
MultiMessageValidator {
    public String formatedMessage;
    AutomatedInstallData adata = AutomatedInstallData.getInstance();

    @Override
    public Validator.Status validate(ProcessingClient client) {
        if (!this.validJarPath(client.getText(), this.adata.langpack)) {
            return Validator.Status.ERROR;
        }
        return Validator.Status.OK;
    }

    @Override
    public String getMessage() {
        return this.formatedMessage;
    }

    public void setFormattedMessage(String message) {
        this.formatedMessage = message;
    }

    private boolean validJarPath(String jarPath, LocaleDatabase langpack) {
        switch (JarUtils.verifyJarPath(jarPath)) {
            case 0: {
                break;
            }
            case 1: {
                this.setFormattedMessage(String.format(langpack.getString("Jsf.path.error"), jarPath));
                return false;
            }
            case 2: {
                this.setFormattedMessage(String.format(langpack.getString("Jsf.path.notzip"), jarPath));
                return false;
            }
            case 3: {
                this.setFormattedMessage(String.format(langpack.getString("Jsf.path.emptyzip"), jarPath));
                return false;
            }
            case 4: {
                this.setFormattedMessage(String.format(langpack.getString("Jsf.path.remote.error"), jarPath));
                return false;
            }
            case 5: {
                this.setFormattedMessage(String.format(langpack.getString("Jsf.path.exception.error"), jarPath));
                return false;
            }
        }
        return true;
    }
}

