/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.jsf;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.asconfiguration.utils.JarUtils;
import java.io.IOException;
import java.util.jar.JarFile;

public class VerifyJsfJars
implements DataValidator {
    private String formattedMessage;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        String apiJarTmpPath = adata.getVariable("jsfapi.input.tmp");
        String implJarPathTmpPath = adata.getVariable("jsfimpl.input.tmp");
        String apiJarPath = apiJarTmpPath == null ? adata.getVariable("jsfapi.input") : apiJarTmpPath;
        String implJarPath = implJarPathTmpPath == null ? adata.getVariable("jsfimpl.input") : implJarPathTmpPath;
        String combinedMsg = adata.getVariable("jsf.validator.combined.msg");
        try (JarFile apiJar = JarUtils.getJarFromPath(apiJarPath);
             JarFile implJar = JarUtils.getJarFromPath(implJarPath);){
            if (!this.getJarTypeFromPomAndManifest(apiJar, "api")) {
                combinedMsg = combinedMsg + String.format(adata.langpack.getString("jsf.error.invalid.api"), apiJarPath) + "\n";
                adata.setVariable("jsf.validator.combined.msg", combinedMsg);
            }
            if (!this.getJarTypeFromPomAndManifest(implJar, "impl")) {
                combinedMsg = combinedMsg + String.format(adata.langpack.getString("jsf.error.invalid.impl"), implJarPath) + "\n";
                adata.setVariable("jsf.validator.combined.msg", combinedMsg);
            }
        }
        catch (IOException e) {
            this.setFormattedMessage(String.format(adata.langpack.getString("JBossJsfSetupPanel.error.JarError"), apiJarPath));
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    public boolean getJarTypeFromPomAndManifest(JarFile jar, String type) throws IOException {
        boolean isType = JarUtils.checkValueOfResource(jar, JarUtils.POM_PATH, "artifactId", type);
        isType = !isType ? JarUtils.checkValueOfResource(jar, JarUtils.MANIFEST_PATH, "Bundle-Description", type) : isType;
        return isType;
    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    public void setFormattedMessage(String message) {
        this.formattedMessage = message;
    }

    @Override
    public String getFormattedMessage() {
        return this.formattedMessage;
    }
}

