/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.jsf;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.SetWarningDefault;
import com.redhat.installer.asconfiguration.utils.JarUtils;
import java.io.IOException;
import java.util.jar.JarFile;

public class VerifyJsfProjectValidator
implements DataValidator,
SetWarningDefault {
    String formattedMessage;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        String jarPath;
        String combinedMsg = adata.getVariable("jsf.validator.combined.msg");
        String currentTurn = adata.getVariable("jsf.to.validate.project");
        String jarTmpPath = adata.getVariable(currentTurn + ".tmp");
        String string = jarPath = jarTmpPath == null ? adata.getVariable(currentTurn) : jarTmpPath;
        if (currentTurn.contains("api")) {
            adata.setVariable("jsf.to.validate.project", "jsfimpl.input");
        } else {
            adata.setVariable("jsf.to.validate.project", "jsfapi.input");
        }
        String adataproj = adata.getVariable("jsf.project.name");
        if (jarPath == null || adataproj == null) {
            this.setFormattedMessage(adata.langpack.getString("jsf.error.missing.xml.info"));
            return DataValidator.Status.ERROR;
        }
        try (JarFile jar = JarUtils.getJarFromPath(jarPath);){
            Boolean isMojarra = this.getProjectFromPomAndManifest(jar, "mojarra");
            Boolean isMyfaces = this.getProjectFromPomAndManifest(jar, "myfaces");
            if (!isMojarra.booleanValue() && !isMyfaces.booleanValue()) {
                if (adataproj.equals("auto")) {
                    this.setFormattedMessage(adata.langpack.getString("empty.fields.project"));
                    adata.setVariable("jsf.validator.combined.msg", "");
                    DataValidator.Status status = DataValidator.Status.ERROR;
                    return status;
                }
                combinedMsg = combinedMsg + String.format(adata.langpack.getString("JBossJsfSetupPanel.error.manifest"), jarPath) + "\n";
                adata.setVariable("jsf.validator.combined.msg", combinedMsg);
                DataValidator.Status status = DataValidator.Status.OK;
                return status;
            }
            if (adataproj.equals("auto")) {
                String proj = isMojarra != false ? "Mojarra" : "MyFaces";
                adata.setVariable("jsf.project.name", proj.toLowerCase());
                this.setFormattedMessage(String.format(adata.langpack.getString("JBossJsfSetupPanel.setproject"), proj));
                DataValidator.Status status = DataValidator.Status.WARNING;
                return status;
            }
            if (!adataproj.equals("mojarra") || !isMyfaces.booleanValue()) {
                if (!adataproj.equals("myfaces")) return DataValidator.Status.OK;
                if (isMojarra == false) return DataValidator.Status.OK;
            }
            combinedMsg = combinedMsg + String.format(adata.langpack.getString("JBossJsfSetupPanel.error.ProjectMatch"), jarPath) + "\n";
            adata.setVariable("jsf.validator.combined.msg", combinedMsg);
            DataValidator.Status status = DataValidator.Status.OK;
            return status;
        }
        catch (IOException e) {
            this.setFormattedMessage(String.format(adata.langpack.getString("JBossJsfSetupPanel.error.JarError"), jarPath));
            adata.setVariable("jsf.validator.combined.msg", "");
            return DataValidator.Status.ERROR;
        }
    }

    private boolean getProjectFromPomAndManifest(JarFile jar, String proj) throws IOException {
        String value = proj.equals("myfaces") ? "myfaces-" : "jsf-";
        boolean isProject = JarUtils.checkValueOfResource(jar, JarUtils.POM_PATH, "artifactId", value);
        isProject = !isProject ? JarUtils.checkValueOfResource(jar, JarUtils.MANIFEST_PATH, "Implementation-Title", proj) : isProject;
        return isProject;
    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public boolean warningDefault() {
        return true;
    }

    @Override
    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public void setFormattedMessage(String message) {
        this.formattedMessage = message;
    }
}

