/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.jsf;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.SetWarningDefault;
import com.redhat.installer.asconfiguration.jsf.JsfUtils;
import com.redhat.installer.asconfiguration.utils.JarUtils;
import java.io.IOException;
import java.util.jar.JarFile;

public class VerifyJsfVersionValidator
implements DataValidator,
SetWarningDefault {
    private String formattedMessage;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        String jarPath;
        String combinedMsg = adata.getVariable("jsf.validator.combined.msg");
        String currentTurn = adata.getVariable("jsf.to.validate.version");
        String jarTmpPath = adata.getVariable(currentTurn + ".tmp");
        String string = jarPath = jarTmpPath == null ? adata.getVariable(currentTurn) : jarTmpPath;
        if (currentTurn.contains("api")) {
            adata.setVariable("jsf.to.validate.version", "jsfimpl.input");
        } else {
            adata.setVariable("jsf.to.validate.version", "jsfapi.input");
        }
        String adataVer = adata.getVariable("jsf.version");
        if (jarPath == null || adataVer == null) {
            this.setFormattedMessage(adata.langpack.getString("jsf.error.missing.xml.info"));
            return DataValidator.Status.ERROR;
        }
        try (JarFile jar = JarUtils.getJarFromPath(jarPath);){
            String threeDigitAdataVer;
            String ver = this.getVersionFromPomAndManifest(jar);
            String cleanedVer = JsfUtils.cleanedVer(ver);
            String cleanedAdataVer = JsfUtils.cleanedVer(adataVer);
            String twoDigitVer = cleanedVer.length() > 2 ? cleanedVer.substring(0, 3) : "";
            String twoDigitAdataVer = cleanedAdataVer.length() > 2 ? cleanedAdataVer.substring(0, 3) : "";
            String threeDigitVer = cleanedVer.length() > 4 ? cleanedVer.substring(0, 5) : "";
            String string2 = threeDigitAdataVer = cleanedAdataVer.length() > 4 ? cleanedAdataVer.substring(0, 5) : "";
            if (ver.equals("")) {
                if (adataVer.equals("")) {
                    this.setFormattedMessage(adata.langpack.getString("empty.fields.version"));
                    adata.setVariable("jsf.validator.combined.msg", "");
                    DataValidator.Status status = DataValidator.Status.ERROR;
                    return status;
                }
                combinedMsg = combinedMsg + String.format(adata.langpack.getString("JBossJsfSetupPanel.error.NoPom"), jarPath) + "\n";
                adata.setVariable("jsf.validator.combined.msg", combinedMsg);
                DataValidator.Status status = DataValidator.Status.OK;
                return status;
            }
            if (cleanedVer.equals("")) {
                this.setFormattedMessage(String.format(adata.langpack.getString("jsf.version.not.supported"), ver));
                adata.setVariable("jsf.validator.combined.msg", "");
                DataValidator.Status status = DataValidator.Status.ERROR;
                return status;
            }
            if (!twoDigitVer.equals(twoDigitAdataVer)) {
                if (adataVer.equals("")) {
                    adata.setVariable("jsf.version", ver);
                    this.setFormattedMessage(String.format(adata.langpack.getString("JBossJsfSetupPanel.setversion"), ver));
                    DataValidator.Status status = DataValidator.Status.WARNING;
                    return status;
                }
                combinedMsg = combinedMsg + String.format(adata.langpack.getString("JBossJsfSetupPanel.error.VersionMatch"), adataVer, ver, jarPath) + "\n";
                adata.setVariable("jsf.validator.combined.msg", combinedMsg);
                DataValidator.Status status = DataValidator.Status.OK;
                return status;
            }
            if (threeDigitAdataVer.equals("")) return DataValidator.Status.OK;
            if (threeDigitVer.equals("")) return DataValidator.Status.OK;
            if (threeDigitAdataVer.equals(threeDigitVer)) return DataValidator.Status.OK;
            combinedMsg = combinedMsg + String.format(adata.langpack.getString("JBossJsfSetupPanel.error.VersionMatch"), adataVer, ver, jarPath) + "\n";
            adata.setVariable("jsf.validator.combined.msg", combinedMsg);
            DataValidator.Status status = DataValidator.Status.OK;
            return status;
        }
        catch (IOException e) {
            this.setFormattedMessage(String.format(adata.langpack.getString("JBossJsfSetupPanel.error.JarError"), jarPath));
            adata.setVariable("jsf.validator.combined.msg", "");
            return DataValidator.Status.ERROR;
        }
    }

    private String getVersionFromPomAndManifest(JarFile jar) throws IOException {
        String version = JarUtils.getResourceFromJar(jar, JarUtils.POM_PATH, "version");
        version = version.equals("") ? JarUtils.getResourceFromJar(jar, JarUtils.MANIFEST_PATH, "Bundle-Version") : version;
        return version;
    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public boolean warningDefault() {
        return true;
    }

    @Override
    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public void setFormattedMessage(String message) {
        this.formattedMessage = message;
    }
}

