/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.keystore.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import com.redhat.installer.asconfiguration.keystore.processpanel.KeystoreGenerator;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import com.redhat.installer.installation.util.InstallationUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class ClientKeystoreBuilder {
    private static final String ARG_NUMBER = "number";
    private static final String ARG_CLIENT_PATH = "client-path";
    private static final String ARG_CLIENT_PWD = "client-password";
    private static final String ARG_CERT_PATH = "cert-path";
    private static final String CLIENT_NAME_TEMPLATE = "client%s.keystore.jks";
    private static final String ARG_SERVER_ALIAS = "server-alias";
    private static AutomatedInstallData idata;
    private static AbstractUIProcessHandler mHandler;

    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        String serverAlias;
        String clientPassword;
        String clientsPath;
        String certPath;
        int numberOfKeystores;
        idata = AutomatedInstallData.getInstance();
        boolean defaultGenerate = idata.getRules().isConditionTrue("generate.client.keystores");
        mHandler = handler;
        ArgumentParser parser = new ArgumentParser();
        parser.deepParse(args);
        if (!parser.hasProperty(ARG_NUMBER) || !parser.hasProperty(ARG_CLIENT_PATH)) {
            ProcessPanelHelper.printToPanel(mHandler, ClientKeystoreBuilder.idata.langpack.getString("ClientKeystoreGenerator.args.error"), true);
            return false;
        }
        try {
            numberOfKeystores = Integer.parseInt(parser.getStringProperty(ARG_NUMBER));
            certPath = parser.getStringProperty(ARG_CERT_PATH);
            clientsPath = parser.getStringProperty(ARG_CLIENT_PATH);
            clientPassword = parser.getStringProperty(ARG_CLIENT_PWD);
            serverAlias = parser.getStringProperty(ARG_SERVER_ALIAS);
        }
        catch (NumberFormatException e) {
            ProcessPanelHelper.printToPanel(mHandler, ClientKeystoreBuilder.idata.langpack.getString("ClientKeystoreGenerator.numeric.arg.error"), true);
            return false;
        }
        catch (NoSuchElementException e) {
            ProcessPanelHelper.printToPanel(mHandler, ClientKeystoreBuilder.idata.langpack.getString("ClientKeystoreGenerator.missing.args.error"), true);
            return false;
        }
        return ClientKeystoreBuilder.buildClientKeystores(defaultGenerate, numberOfKeystores, clientsPath, certPath, clientPassword, serverAlias);
    }

    private static boolean buildClientKeystores(boolean defaultGenerate, int numberOfKeystores, String pathToClients, String pathToCertificate, String clientPassword, String serverAlias) {
        File clientLocation = new File(pathToClients);
        if (clientLocation.exists()) {
            if (clientLocation.isFile()) {
                Debug.log("importing server certificate into  user specified client keystore: " + clientLocation.getAbsolutePath());
                if (ClientKeystoreBuilder.aliasClash(clientLocation, clientPassword, serverAlias)) {
                    serverAlias = serverAlias + System.currentTimeMillis();
                }
                if (!ClientKeystoreBuilder.importServerCertificate(clientLocation.getAbsolutePath(), clientPassword, pathToCertificate, serverAlias)) {
                    return false;
                }
            } else if (clientLocation.isDirectory()) {
                if (clientLocation.listFiles().length == 0) {
                    ClientKeystoreBuilder.createKeystoresInDirectory(numberOfKeystores, pathToClients, clientPassword, pathToCertificate, serverAlias);
                    InstallationUtilities.addFileToCleanupList(pathToClients);
                } else {
                    for (File keystore : clientLocation.listFiles()) {
                        if (keystore.isDirectory()) continue;
                        Debug.log("Importing server certificate into keystore: " + keystore.getAbsolutePath());
                        if (ClientKeystoreBuilder.aliasClash(keystore, clientPassword, serverAlias)) {
                            serverAlias = serverAlias + System.currentTimeMillis();
                        }
                        if (ClientKeystoreBuilder.importServerCertificate(keystore.getAbsolutePath(), clientPassword, pathToCertificate, serverAlias)) continue;
                        return false;
                    }
                }
            }
        } else if (!clientLocation.exists()) {
            clientLocation.mkdirs();
            if (!ClientKeystoreBuilder.createKeystoresInDirectory(numberOfKeystores, pathToClients, clientPassword, pathToCertificate, serverAlias)) {
                return false;
            }
            InstallationUtilities.addFileToCleanupList(pathToClients);
        }
        return true;
    }

    private static boolean createKeystoresInDirectory(int numberOfKeystores, String destinationPath, String clientPassword, String pathToCertificate, String serverAlias) {
        for (int i = 0; i < numberOfKeystores; ++i) {
            String alias = String.format(CLIENT_NAME_TEMPLATE, i);
            String path = destinationPath + File.separator + alias;
            Debug.log("Generating client keystore: " + new File(path).getAbsolutePath());
            if (!ClientKeystoreBuilder.buildClientKeystore(path, clientPassword, alias)) {
                return false;
            }
            Debug.log("Importing Certificate:");
            if (ClientKeystoreBuilder.importServerCertificate(path, clientPassword, pathToCertificate, serverAlias)) continue;
            return false;
        }
        return true;
    }

    private static boolean aliasClash(File keystore, String password, String alias) {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fileIn = new FileInputStream(keystore.getAbsolutePath());
            ks.load(fileIn, password.toCharArray());
            fileIn.close();
            return ks.containsAlias(alias);
        }
        catch (KeyStoreException e) {
            Debug.log(e.getMessage());
            return false;
        }
        catch (CertificateException e) {
            Debug.log(e.getMessage());
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            Debug.log(e.getMessage());
            return false;
        }
        catch (FileNotFoundException e) {
            Debug.log(e.getMessage());
            return false;
        }
        catch (IOException e) {
            Debug.log(e.getMessage());
            return false;
        }
    }

    private static boolean buildClientKeystore(String location, String password, String alias) {
        boolean result = false;
        HashMap<String, String> genKeyStoreArgsMap = new HashMap<String, String>();
        genKeyStoreArgsMap.put("-genkeypair", "");
        genKeyStoreArgsMap.put("-keystore", location);
        genKeyStoreArgsMap.put("-storepass", password);
        genKeyStoreArgsMap.put("-keypass", password);
        genKeyStoreArgsMap.put("-keysize", "1024");
        genKeyStoreArgsMap.put("-keyalg", "RSA");
        genKeyStoreArgsMap.put("-alias", alias);
        genKeyStoreArgsMap.put("-storetype", "jks");
        genKeyStoreArgsMap.put("-validity", "36500");
        genKeyStoreArgsMap.put("-dname", "CN=Picketbox Vault,OU=JBoss,O=RedHat,L=Westford,ST=Mass,C=US");
        ArrayList<String> args = ClientKeystoreBuilder.mapToArrayList(genKeyStoreArgsMap);
        try {
            result = KeystoreGenerator.runKeytool(args);
        }
        catch (Exception e) {
            Debug.log(e.getStackTrace());
        }
        return result;
    }

    private static boolean importServerCertificate(String pathToClient, String clientPassword, String pathToCertificate, String serverAlias) {
        HashMap<String, String> importKeystoreArgs = new HashMap<String, String>();
        importKeystoreArgs.put("-importcert", "");
        importKeystoreArgs.put("-keystore", pathToClient);
        importKeystoreArgs.put("-storepass", clientPassword);
        importKeystoreArgs.put("-keypass", clientPassword);
        importKeystoreArgs.put("-file", pathToCertificate);
        importKeystoreArgs.put("-alias", serverAlias);
        ArrayList<String> args = ClientKeystoreBuilder.mapToArrayList(importKeystoreArgs);
        Debug.log("Importing Server Keystore Certificate");
        try {
            KeystoreGenerator.runKeytool(args);
        }
        catch (Exception e) {
            Debug.log(e.getStackTrace());
            return false;
        }
        return true;
    }

    private static ArrayList<String> mapToArrayList(Map<String, String> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            list.add(key);
            String val = map.get(key);
            if (val == null || val.isEmpty()) continue;
            list.add(val);
        }
        return list;
    }

    public static String getClientKeystoreTemplate() {
        return CLIENT_NAME_TEMPLATE;
    }
}

