/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.keystore.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.keystore.validator.KeystoreValidator;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import com.redhat.installer.installation.util.InstallationUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class KeystoreGenerator {
    private static final String IMPORTCERT = "-importcert";
    private static final String EXPORTCERT = "-exportcert";
    private static final String FILE = "-file";
    private static final String GENKEY = "-genkeypair";
    private static final String SECKEY = "-genseckey";
    private static final String KEYSTORE = "-keystore";
    private static final String KEY_PASS = "-keypass";
    private static final String KEY_SIZE = "-keysize";
    private static final String ALIAS = "-alias";
    private static final String STORE_PASS = "-storepass";
    private static final String DNAME = "-dname";
    private static final String VALIDITY = "-validity";
    private static final String OPERATION = "operation";
    private static final String PARAMETER = "parameter";
    private static final String ALLOW_EXISTING = "allow-existing";
    private static final String PUT_LOCATION_IN_PROPS = "put-location-in-props";
    private static final String[] GENKEY_PARAMS = new String[]{"-keystore", "-keysize", "-alias", "-storepass", "-dname", "-validity"};
    private static final String[] SECKEY_PARAMS = new String[]{"-keystore", "-alias", "-storepass", "-validity"};
    private static final String[] IMPORTEXPORT_PARAMS = new String[]{"-keystore", "-storepass", "-file", "-alias"};
    private static BufferedReader in;
    private static BufferedWriter out;
    private static AutomatedInstallData idata;
    private static AbstractUIProcessHandler mHandler;

    /*
     * Enabled aggressive block sorting
     */
    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        String keystorePath;
        idata = AutomatedInstallData.getInstance();
        mHandler = handler;
        ArgumentParser parser = new ArgumentParser();
        parser.setListDelimiter('\uffff');
        parser.deepParse(args);
        if (!parser.hasProperty(PARAMETER) || !parser.hasProperty(OPERATION)) {
            ProcessPanelHelper.printToPanel(mHandler, KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.paramerror"), true);
            return false;
        }
        String operation = parser.getStringProperty(OPERATION);
        ArrayList<String> keytoolArguments = new ArrayList<String>();
        if (operation.equals(IMPORTCERT) || operation.equals(EXPORTCERT)) {
            if (KeystoreGenerator.missingRequiredParams(parser, IMPORTEXPORT_PARAMS)) {
                ProcessPanelHelper.printToPanel(mHandler, KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.paramerror"), true);
                return false;
            }
            if (!KeystoreGenerator.keystoreExists(parser)) {
                ProcessPanelHelper.printToPanel(mHandler, String.format(KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.notexist.error"), operation, KeystoreGenerator.searchForParameter(parser, KEYSTORE)), false);
            }
        } else if (operation.equals(GENKEY)) {
            if (KeystoreGenerator.missingRequiredParams(parser, GENKEY_PARAMS)) {
                ProcessPanelHelper.printToPanel(mHandler, KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.paramerror"), true);
                return false;
            }
            if (KeystoreGenerator.keystoreExists(parser)) {
                if (parser.hasProperty(ALLOW_EXISTING)) {
                    ProcessPanelHelper.printToPanel(mHandler, String.format(KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.exists.allowed"), KeystoreGenerator.searchForParameter(parser, KEYSTORE)), false);
                    return true;
                }
                ProcessPanelHelper.printToPanel(mHandler, String.format(KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.exists.error"), operation, KeystoreGenerator.searchForParameter(parser, KEYSTORE)), true);
                return false;
            }
            KeystoreGenerator.makeKeystorePath(parser);
            if (!parser.hasProperty(KEY_PASS)) {
                keytoolArguments.add(KEY_PASS);
                keytoolArguments.add(KeystoreGenerator.searchForParameter(parser, STORE_PASS));
            }
        } else {
            if (!operation.equals(SECKEY)) {
                ProcessPanelHelper.printToPanel(mHandler, KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.operation.unsupported"), true);
                return false;
            }
            if (KeystoreGenerator.missingRequiredParams(parser, SECKEY_PARAMS)) {
                ProcessPanelHelper.printToPanel(mHandler, KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.paramerror"), true);
                return false;
            }
            if (KeystoreGenerator.keystoreExists(parser)) {
                if (!parser.hasProperty(ALLOW_EXISTING)) {
                    ProcessPanelHelper.printToPanel(mHandler, String.format(KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.exists.error"), operation, KeystoreGenerator.searchForParameter(parser, KEYSTORE)), true);
                    return false;
                }
                ProcessPanelHelper.printToPanel(mHandler, String.format(KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.exists.allowed"), KeystoreGenerator.searchForParameter(parser, KEYSTORE)), false);
            } else {
                KeystoreGenerator.makeKeystorePath(parser);
            }
            if (!parser.hasProperty(KEY_PASS)) {
                keytoolArguments.add(KEY_PASS);
                keytoolArguments.add(KeystoreGenerator.searchForParameter(parser, STORE_PASS));
            }
        }
        keytoolArguments.add(operation);
        Map<String, String> keytoolParameters = KeystoreGenerator.processParameters(parser);
        for (String key : keytoolParameters.keySet()) {
            keytoolArguments.add(key);
            keytoolArguments.add(keytoolParameters.get(key));
        }
        if (parser.hasProperty(PUT_LOCATION_IN_PROPS) && (keystorePath = KeystoreGenerator.searchForParameter(parser, KEYSTORE)) != null) {
            keystorePath = keystorePath.replace('\\', '/');
            System.setProperty(parser.getStringProperty(PUT_LOCATION_IN_PROPS), keystorePath);
        }
        return KeystoreGenerator.runKeytool(keytoolArguments);
    }

    private static Map<String, String> processParameters(ArgumentParser parser) {
        HashMap<String, String> retVal = new HashMap<String, String>();
        for (String param : parser.getListProperty(PARAMETER)) {
            String key = param.substring(0, param.indexOf(32));
            String value = KeystoreGenerator.extractArgumentValue(param);
            retVal.put(key, value);
        }
        return retVal;
    }

    private static boolean keystoreExists(ArgumentParser parser) {
        String keystoreLocation = KeystoreGenerator.searchForParameter(parser, KEYSTORE);
        String password = KeystoreGenerator.searchForParameter(parser, STORE_PASS);
        if (keystoreLocation == null || password == null) {
            ProcessPanelHelper.printToPanel(mHandler, KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.paramerror"), true);
            return false;
        }
        switch (KeystoreValidator.isValidKeystore(keystoreLocation, password.toCharArray(), new String[]{"JKS", "JCEKS", "PKCS11", "PKCS12"})) {
            case 0: 
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private static void makeKeystorePath(ArgumentParser parser) {
        String path = KeystoreGenerator.searchForParameter(parser, KEYSTORE);
        File keystoreFile = new File(path);
        File parentFile = keystoreFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
    }

    private static boolean missingRequiredParams(ArgumentParser parser, String[] requiredParams) {
        for (String arg : requiredParams) {
            if (KeystoreGenerator.searchForParameter(parser, arg) != null) continue;
            ProcessPanelHelper.printToPanel(mHandler, String.format("Missing required parameter: %s", arg), true);
            return true;
        }
        return false;
    }

    public static boolean runKeytool(ArrayList<String> otherKeytoolArguments) {
        ArrayList<String> keytoolArguments = new ArrayList<String>();
        keytoolArguments.add("keytool");
        keytoolArguments.add("-debug");
        keytoolArguments.add("-noprompt");
        keytoolArguments.addAll(otherKeytoolArguments);
        String keystorePath = null;
        String operation = null;
        for (String arg : otherKeytoolArguments) {
            if (arg.equals(KEYSTORE)) {
                keystorePath = new File(otherKeytoolArguments.get(otherKeytoolArguments.indexOf(arg) + 1)).getAbsolutePath();
                continue;
            }
            if (!arg.equals(IMPORTCERT) && !arg.equals(EXPORTCERT) && !arg.equals(GENKEY) && !arg.equals(SECKEY)) continue;
            operation = arg;
        }
        ProcessPanelHelper.printToPanel(mHandler, String.format(KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.start"), operation, keystorePath), false);
        String[] args = new String[7];
        String[] realArgs = keytoolArguments.toArray(args);
        for (int tries = 0; tries < 2; ++tries) {
            try {
                ProcessBuilder pb = new ProcessBuilder(realArgs);
                pb.redirectErrorStream(true);
                Process p = pb.start();
                in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                out = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
                Thread eater = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String line;
                            while ((line = in.readLine()) != null) {
                                if (!line.startsWith("Command line args:")) {
                                    ProcessPanelHelper.printToPanel(mHandler, line, false);
                                }
                                out.flush();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                eater.start();
                int retVal = p.waitFor();
                in.close();
                out.close();
                if (retVal != 0) {
                    ProcessPanelHelper.printToPanel(mHandler, String.format(KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.error"), operation, keystorePath), true);
                    return false;
                }
                ProcessPanelHelper.printToPanel(mHandler, String.format(KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.success"), operation, keystorePath), false);
                InstallationUtilities.addFileToCleanupList(keystorePath);
                return true;
            }
            catch (Exception e) {
                String keytoolFromJre;
                if (tries > 0) {
                    e.printStackTrace();
                }
                realArgs[0] = keytoolFromJre = System.getProperty("java.home") + File.separator + "bin" + File.separator + "keytool";
                continue;
            }
        }
        ProcessPanelHelper.printToPanel(mHandler, String.format(KeystoreGenerator.idata.langpack.getString("KeystoreGenerator.error"), operation, keystorePath), true);
        return false;
    }

    private static String searchForParameter(ArgumentParser p, String paramName) {
        for (String argument : p.getListProperty(PARAMETER)) {
            if (!argument.startsWith(paramName)) continue;
            return KeystoreGenerator.extractArgumentValue(argument);
        }
        return null;
    }

    private static String extractArgumentValue(String argument) {
        return argument.substring(argument.indexOf(32) + 1);
    }
}

