/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.keystore.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.asconfiguration.keystore.validator.KeystoreValidator;
import java.io.File;

public class JMSKeystoreValidator
implements DataValidator {
    private static final String[] supportedFormats = new String[]{"JKS", "JCEKS", "CASEEXACTJKS"};
    private String message;
    private String warningId;

    public char[] getKeystorePassword() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String pwd = idata.getVariable("generated.keystores.client.storepass");
        return pwd != null ? pwd.toCharArray() : null;
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        if (idata.getRules().isConditionTrue("generate.client.keystores")) {
            return DataValidator.Status.OK;
        }
        String givenLocation = idata.getVariable("existing.keystores.client.location");
        char[] givenPassword = idata.getVariable("generated.keystores.client.storepass").toCharArray();
        File givenFile = new File(givenLocation);
        int result = 0;
        if (givenFile.exists()) {
            if (givenFile.isFile()) {
                result = KeystoreValidator.isValidKeystore(givenFile.getAbsolutePath(), givenPassword, supportedFormats);
                if (result != 0) {
                    return this.evaluateKeystoreValidatorResult(givenFile.getAbsolutePath(), result);
                }
            } else if (givenFile.isDirectory()) {
                if (givenFile.listFiles().length == 0) {
                    this.setMessage(String.format(idata.langpack.getString("JMSKeystoreValidator.empty.dir"), givenFile.getAbsoluteFile()));
                    return DataValidator.Status.ERROR;
                }
                for (File file : givenFile.listFiles()) {
                    if (file.isDirectory() || (result = KeystoreValidator.isValidKeystore(file.getAbsolutePath(), givenPassword, supportedFormats)) == 0) continue;
                    return this.evaluateKeystoreValidatorResult(file.getAbsolutePath(), result);
                }
            }
        } else {
            this.setMessage(String.format(idata.langpack.getString("JMSKeystoreValidator.file.not.exist"), givenFile.getAbsolutePath()));
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    private DataValidator.Status evaluateKeystoreValidatorResult(String keystore, int result) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String messagePrefix = String.format(idata.langpack.getString("JMSKeystoreValidator.message.prefix"), keystore);
        DataValidator.Status currentStatus = DataValidator.Status.OK;
        switch (result) {
            case 1: {
                this.setWarningId("keystore.validator.authentication.failure");
                this.setMessage(messagePrefix + String.format(idata.langpack.getString("keystore.validator.authentication.failure"), new Object[0]));
                currentStatus = DataValidator.Status.WARNING;
                break;
            }
            case 2: {
                this.setWarningId("keystore.validator.file.does.not.exist");
                this.setMessage(messagePrefix + String.format(idata.langpack.getString("JMSKeystoreValidator.is.directory"), new Object[0]));
                currentStatus = DataValidator.Status.ERROR;
                break;
            }
            case 3: {
                this.setWarningId("keystore.validator.jvm.cannot.read");
                this.setMessage(messagePrefix + String.format(idata.langpack.getString("keystore.validator.jvm.cannot.read"), new Object[0]));
                currentStatus = DataValidator.Status.WARNING;
                break;
            }
            case 4: 
            case 5: {
                this.setWarningId("keystore.validator.invalid.url");
                this.setMessage(messagePrefix + String.format(idata.langpack.getString("keystore.validator.invalid.url"), new Object[0]));
                currentStatus = DataValidator.Status.WARNING;
                break;
            }
            case 6: {
                this.setWarningId("keystore.validator.file.is.empty");
                this.setMessage(messagePrefix + String.format(idata.langpack.getString("keystore.validator.file.is.empty"), new Object[0]));
                currentStatus = DataValidator.Status.ERROR;
                break;
            }
            case 7: {
                this.setWarningId("keystore.validator.not.supported");
                this.setMessage(messagePrefix + String.format(idata.langpack.getString("keystore.validator.not.supported"), new Object[0]));
                currentStatus = DataValidator.Status.ERROR;
            }
        }
        return currentStatus;
    }

    @Override
    public String getErrorMessageId() {
        return this.warningId;
    }

    @Override
    public String getWarningMessageId() {
        return this.warningId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setWarningId(String warningId) {
        this.warningId = warningId;
    }
}

