/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.keystore.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.asconfiguration.keystore.validator.KeystoreValidator;
import java.util.Properties;

public class JSSEValidator
implements DataValidator {
    String message;
    String error;
    String warning;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        Properties variables = idata.getVariables();
        String isKeyStore = (String)variables.get("securityDomainJsseAddKeystore");
        String isTrustStore = (String)variables.get("securityDomainJsseAddTruststore");
        String keystorePwd = (String)variables.get("securitydomain.jsse.keystore.password");
        String keystoreUrl = (String)variables.get("securitydomain.jsse.keystore.url");
        String keystoreType = (String)variables.get("securitydomain.jsse.keystore.type");
        String truststorePwd = (String)variables.get("securitydomain.jsse.truststore.password");
        String truststoreUrl = (String)variables.get("securitydomain.jsse.truststore.url");
        String truststoreType = (String)variables.get("securitydomain.jsse.truststore.type");
        DataValidator.Status keyStoreStatus = DataValidator.Status.OK;
        DataValidator.Status trustStoreStatus = DataValidator.Status.OK;
        boolean installTruststore = Boolean.parseBoolean(isTrustStore);
        boolean installKeystore = Boolean.parseBoolean(isKeyStore);
        if (idata.getVariable("securityDomainAddJsse").contains("false")) {
            return DataValidator.Status.OK;
        }
        if (installKeystore) {
            switch (this.validateKeystore(keystorePwd, keystoreUrl, idata, keystoreType)) {
                case 0: {
                    keyStoreStatus = DataValidator.Status.OK;
                    break;
                }
                case 1: {
                    this.warning = "securitydomain.jsse.keystore.passincorrect";
                    this.message = idata.langpack.getString(this.warning);
                    keyStoreStatus = DataValidator.Status.WARNING;
                    break;
                }
                case 2: {
                    this.warning = "securitydomain.jsse.keystore.inaccessible";
                    this.message = idata.langpack.getString(this.warning);
                    keyStoreStatus = DataValidator.Status.WARNING;
                    break;
                }
                case 3: {
                    this.warning = "securitydomain.jsse.keystore.invalid";
                    this.message = idata.langpack.getString(this.warning);
                    keyStoreStatus = DataValidator.Status.WARNING;
                    break;
                }
                case 4: {
                    this.error = "securitydomain.jsse.keystore.encoding";
                    this.message = idata.langpack.getString(this.error);
                    keyStoreStatus = DataValidator.Status.ERROR;
                    break;
                }
                case 5: {
                    this.error = "securitydomain.jsse.keystore.absolute";
                    this.message = idata.langpack.getString(this.error);
                    keyStoreStatus = DataValidator.Status.ERROR;
                    break;
                }
                case 6: {
                    this.error = "securitydomain.jsse.keystore.reqs";
                    this.message = idata.langpack.getString(this.error);
                    keyStoreStatus = DataValidator.Status.ERROR;
                    break;
                }
                case 7: {
                    this.error = "securitydomain.jsse.keystore.wrongtype";
                    this.message = idata.langpack.getString(this.error);
                    keyStoreStatus = DataValidator.Status.ERROR;
                }
            }
        }
        if (installTruststore) {
            switch (this.validateKeystore(truststorePwd, truststoreUrl, idata, truststoreType)) {
                case 0: {
                    trustStoreStatus = DataValidator.Status.OK;
                    break;
                }
                case 1: {
                    this.warning = "securitydomain.jsse.truststore.passincorrect";
                    this.message = idata.langpack.getString(this.warning);
                    trustStoreStatus = DataValidator.Status.WARNING;
                    break;
                }
                case 2: {
                    this.warning = "securitydomain.jsse.truststore.inaccessible";
                    this.message = idata.langpack.getString(this.warning);
                    trustStoreStatus = DataValidator.Status.WARNING;
                    break;
                }
                case 3: {
                    this.warning = "securitydomain.jsse.keystore.invalid";
                    this.message = idata.langpack.getString(this.warning);
                    trustStoreStatus = DataValidator.Status.WARNING;
                    break;
                }
                case 4: {
                    this.error = "securitydomain.jsse.truststore.encoding";
                    this.message = idata.langpack.getString(this.error);
                    trustStoreStatus = DataValidator.Status.ERROR;
                    break;
                }
                case 5: {
                    this.warning = "securitydomain.jsse.truststore.absolute";
                    this.message = idata.langpack.getString(this.warning);
                    trustStoreStatus = DataValidator.Status.WARNING;
                    break;
                }
                case 6: {
                    this.error = "securitydomain.jsse.truststore.reqs";
                    this.message = idata.langpack.getString(this.error);
                    trustStoreStatus = DataValidator.Status.ERROR;
                    break;
                }
                case 7: {
                    this.error = "securitydomain.jsse.truststore.wrongtype";
                    this.message = idata.langpack.getString(this.error);
                    trustStoreStatus = DataValidator.Status.ERROR;
                }
            }
        }
        if (!installTruststore && !installKeystore) {
            this.error = "securitydomain.jsse.requirements";
            this.message = idata.langpack.getString(this.error);
            return DataValidator.Status.ERROR;
        }
        if (installKeystore && keystoreType.equals("PKCS11") || installTruststore && truststoreType.equals("PKCS11")) {
            this.error = "securitydomain.jsse.keystore.pkcs11.warning";
            this.message = idata.langpack.getString(this.error);
            return DataValidator.Status.WARNING;
        }
        if (keyStoreStatus != DataValidator.Status.OK) {
            return keyStoreStatus;
        }
        if (trustStoreStatus != DataValidator.Status.OK) {
            return trustStoreStatus;
        }
        return DataValidator.Status.OK;
    }

    private boolean nullOrEmpty(String ... values) {
        boolean anyFailure = false;
        for (String value : values) {
            if (value != null && !value.isEmpty()) continue;
            anyFailure = true;
        }
        return anyFailure;
    }

    private int validateKeystore(String keyPwd, String keyUrl, AutomatedInstallData idata, String storeType) {
        if (this.nullOrEmpty(keyPwd, keyUrl)) {
            this.error = "securitydomain.jsse.keystore.reqs";
            this.message = idata.langpack.getString(this.error);
            return 6;
        }
        String[] storeTypes = storeType.equalsIgnoreCase("JKS") ? new String[]{"CASEEXACTJKS", storeType} : new String[]{storeType};
        return KeystoreValidator.isValidKeystore(keyUrl, keyPwd.toCharArray(), storeTypes);
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return this.warning;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }
}

