/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.keystore.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.VariableSubstitutor;
import com.redhat.installer.asconfiguration.keystore.processpanel.ClientKeystoreBuilder;
import java.io.File;

public class KeystoreClashValidator
implements DataValidator {
    private final String CONDITION = "generate.client.keystores";
    private final String SERVER_LOC_VAR = "generated.keystores.server.location";
    private final String CLIENT_LOC_VAR = "generated.keystores.client.location";
    private final String CLIENT_NUM_VAR = "generated.keystores.client.number";
    private String error;
    private String message;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        File checkServer;
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        String serverStorePath = vs.substitute(idata.getVariable("generated.keystores.server.location"));
        if (serverStorePath != null && (checkServer = new File(serverStorePath)).exists()) {
            this.setError("KeystoreClashValidator.generated.server.keystore.path.exists");
            this.setMessage(String.format(idata.langpack.getString(this.getErrorMessageId()), checkServer.getAbsolutePath()));
            return DataValidator.Status.ERROR;
        }
        if (idata.getRules().isConditionTrue("generate.client.keystores")) {
            int numGeneratedClients = Integer.parseInt(idata.getVariable("generated.keystores.client.number"));
            String clientBasePath = vs.substitute(idata.getVariable("generated.keystores.client.location"));
            File checkDir = new File(clientBasePath);
            if (checkDir.isFile()) {
                this.setError("KeystoreClashValidator.generated.client.keystore.path.isfile");
                this.setMessage(String.format(idata.langpack.getString(this.getErrorMessageId()), checkDir.getAbsolutePath()));
                return DataValidator.Status.ERROR;
            }
            if (checkDir.exists() && checkDir.listFiles().length > 0) {
                this.setError("KeystoreClashValidator.generated.client.keystore.path.non.empty");
                this.setMessage(String.format(idata.langpack.getString(this.getErrorMessageId()), checkDir.getAbsoluteFile()));
                return DataValidator.Status.ERROR;
            }
            for (int i = 0; i < numGeneratedClients; ++i) {
                File checkFile = new File(clientBasePath + File.separator + String.format(ClientKeystoreBuilder.getClientKeystoreTemplate(), i));
                if (!checkFile.exists()) continue;
                this.setError("KeystoreClashValidator.generated.client.keystore.clash");
                this.setMessage(String.format(idata.langpack.getString(this.getErrorMessageId()), checkFile.getAbsolutePath()));
                return DataValidator.Status.ERROR;
            }
        }
        return DataValidator.Status.OK;
    }

    private void setError(String s) {
        this.error = s;
    }

    private void setMessage(String s) {
        this.message = s;
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return this.error;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }
}

