/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.keystore.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateException;

public abstract class KeystoreValidator
implements DataValidator {
    private static final String PKCS12_AUTH_ERROR = "Given final block not properly padded";
    private static final String JCEKS_AUTH_ERROR = "Keystore was tampered with, or password was incorrect";
    private static final String JKS_AUTH_ERROR = "Password verification failed";
    private static final String IBM_PKCS12_TYPE_ERROR = "Keystore type is not PKCS12";
    private static final String PKCS12_TYPE_ERROR = "DerInputStream.getLength(): lengthTag=";
    private static final String JCEKS_JKS_TYPE_ERROR = "Invalid keystore format";
    protected String error;
    protected String message;
    private static String lastSuccessfulAlgorithm = "JKS";

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        DataValidator.Status currentStatus = DataValidator.Status.OK;
        String keystoreLoc = this.getKeystorePath();
        if (keystoreLoc.contains("${jboss.home.dir}")) {
            keystoreLoc = keystoreLoc.replace("${jboss.home.dir}", AutomatedInstallData.getInstance().getInstallPath());
        }
        char[] pwd = this.getKeystorePassword();
        int result = 0;
        if (this.getCondition()) {
            boolean checkedJKS = false;
            if (!this.isJKSValid()) {
                result = KeystoreValidator.isValidKeystore(keystoreLoc, pwd, new String[]{"JKS"});
                checkedJKS = true;
            }
            result = checkedJKS && result == 0 ? 7 : KeystoreValidator.isValidKeystore(keystoreLoc, pwd, this.getSupportedFormats());
        }
        switch (result) {
            case 1: {
                this.setError("keystore.validator.authentication.failure");
                this.setMessage(String.format(idata.langpack.getString("keystore.validator.authentication.failure"), new Object[0]));
                currentStatus = DataValidator.Status.WARNING;
                break;
            }
            case 2: {
                this.setError("keystore.validator.file.does.not.exist");
                this.setMessage(String.format(idata.langpack.getString("keystore.validator.file.does.not.exist"), new Object[0]));
                currentStatus = DataValidator.Status.ERROR;
                break;
            }
            case 3: {
                this.setError("keystore.validator.jvm.cannot.read");
                this.setMessage(String.format(idata.langpack.getString("keystore.validator.jvm.cannot.read"), new Object[0]));
                currentStatus = DataValidator.Status.WARNING;
                break;
            }
            case 4: 
            case 5: {
                this.setError("keystore.validator.invalid.url");
                this.setMessage(String.format(idata.langpack.getString("keystore.validator.invalid.url"), new Object[0]));
                currentStatus = DataValidator.Status.WARNING;
                break;
            }
            case 6: {
                this.setError("keystore.validator.file.is.empty");
                this.setMessage(String.format(idata.langpack.getString("keystore.validator.file.is.empty"), new Object[0]));
                currentStatus = DataValidator.Status.ERROR;
                break;
            }
            case 7: {
                this.setError("keystore.validator.not.supported");
                this.setMessage(String.format(idata.langpack.getString("keystore.validator.not.supported"), new Object[0]));
                currentStatus = DataValidator.Status.ERROR;
            }
        }
        if (result != 0) {
            if (this.hasAdditionalChecksOnFail()) {
                return this.performAdditionalChecksOnFail(result);
            }
        } else if (this.hasAdditionalChecksOnSuccess()) {
            return this.performAdditionalChecksOnSuccess(lastSuccessfulAlgorithm);
        }
        this.setVariable();
        return currentStatus;
    }

    public static int isValidKeystore(String keystoreUrl, char[] pwd, String[] supportedFormats) {
        int SUCCESS = 0;
        int AUTHENTICATION_FAILURE = 1;
        int NO_FILE = 2;
        int JVM_NO_PROVIDER = 3;
        int BAD_ENCODING = 4;
        int URI_NOT_ABSOLUTE = 5;
        int EMPTY_FILE = 6;
        int NOT_SUPPORTED = 7;
        int status = SUCCESS;
        if (!KeystoreValidator.isValidReadableFile(keystoreUrl) && !KeystoreValidator.isValidAccessibleUrl(keystoreUrl)) {
            return NO_FILE;
        }
        KeyStore ks = null;
        for (String algorithm : supportedFormats) {
            if (!Security.getAlgorithms("KeyStore").contains(algorithm.toUpperCase()) || algorithm.equalsIgnoreCase("WINDOWS-ROOT") || algorithm.equalsIgnoreCase("WINDOWS-MY")) {
                status = NOT_SUPPORTED;
                continue;
            }
            try {
                ks = KeyStore.getInstance(algorithm);
                if (KeystoreValidator.isValidAccessibleUrl(keystoreUrl)) {
                    ks.load(new URI(keystoreUrl).toURL().openStream(), pwd);
                } else {
                    try (FileInputStream inStream = new FileInputStream(new File(keystoreUrl));){
                        ks.load(inStream, pwd);
                    }
                }
                status = SUCCESS;
                lastSuccessfulAlgorithm = algorithm;
                break;
            }
            catch (IllegalArgumentException iae) {
                return URI_NOT_ABSOLUTE;
            }
            catch (NoSuchAlgorithmException e) {
                status = JVM_NO_PROVIDER;
            }
            catch (CertificateException e) {
                status = JVM_NO_PROVIDER;
            }
            catch (FileNotFoundException e) {
                status = NO_FILE;
            }
            catch (EOFException e) {
                status = EMPTY_FILE;
            }
            catch (IOException e) {
                String causeMessage;
                String message = e.getMessage();
                String string = causeMessage = e.getCause() != null ? e.getCause().getMessage() : "";
                if (message.equals(JCEKS_JKS_TYPE_ERROR) || message.startsWith(PKCS12_TYPE_ERROR) || message.equals(IBM_PKCS12_TYPE_ERROR)) {
                    status = NOT_SUPPORTED;
                    continue;
                }
                if (message.equals(JCEKS_AUTH_ERROR) || causeMessage.equals(PKCS12_AUTH_ERROR) || causeMessage.equals(JKS_AUTH_ERROR)) {
                    status = AUTHENTICATION_FAILURE;
                    return status;
                }
                status = JVM_NO_PROVIDER;
            }
            catch (KeyStoreException e) {
                status = JVM_NO_PROVIDER;
            }
            catch (URISyntaxException e) {
                status = BAD_ENCODING;
            }
        }
        return status;
    }

    public static boolean isValidReadableFile(String file) {
        File check = new File(file);
        return check.exists() && check.canRead() && !check.isDirectory();
    }

    public static boolean isValidAccessibleUrl(String url) {
        try {
            URL check = new URL(url);
            URLConnection conn = check.openConnection();
            conn.connect();
        }
        catch (MalformedURLException e1) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean isJKSValid() {
        String[] supportedFormats = this.getSupportedFormats();
        for (int i = 0; i <= supportedFormats.length - 1; ++i) {
            String format = supportedFormats[i];
            if (!format.toUpperCase().equals("JKS")) continue;
            return true;
        }
        return false;
    }

    public abstract String getKeystorePath();

    public abstract String getEncryptedDirPath();

    public abstract String[] getSupportedFormats();

    public abstract char[] getKeystorePassword();

    public abstract boolean hasAdditionalChecksOnFail();

    public abstract DataValidator.Status performAdditionalChecksOnFail(int var1);

    public abstract void setVariable();

    public abstract DataValidator.Status getFailureStatus();

    protected abstract DataValidator.Status performAdditionalChecksOnSuccess(String var1);

    protected abstract boolean hasAdditionalChecksOnSuccess();

    public String getLangpackKey() {
        return "ssl.password.incorrect";
    }

    protected void setError(String s) {
        this.error = s;
    }

    protected void setMessage(String s) {
        this.message = s;
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return this.error;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    protected abstract boolean getCondition();
}

