/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ldap.utils;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapUtils {
    public static DirContext makeConnection(String dnServer, String searchDn, String dnPassword) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", dnServer);
        env.put("java.naming.security.principal", searchDn);
        env.put("java.naming.security.credentials", dnPassword);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            return ctx;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean validateBaseDn(DirContext ctx, String baseDn, String filter, boolean recursive) {
        try {
            NamingEnumeration<SearchResult> search;
            SearchControls ctls = new SearchControls();
            if (recursive) {
                ctls.setSearchScope(2);
            }
            return (search = ctx.search(baseDn, filter, ctls)).hasMore();
        }
        catch (NamingException ne) {
            return false;
        }
    }
}

