/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ldap.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.UserInputPanel;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.PasswordEqualityValidator;
import com.redhat.installer.asconfiguration.ldap.utils.LdapUtils;
import javax.naming.directory.DirContext;

public class LDAPValidator
implements DataValidator,
Validator {
    String warning;
    String message;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        if (!this.connectToLdapConnection()) {
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    private boolean connectToLdapConnection() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        this.setWarningMessageId("Ldap.error");
        this.message = idata.langpack.getString(this.warning);
        String dnServer = idata.getVariable("ldap.url");
        String dn = idata.getVariable("ldap.dn");
        String dnPassword = idata.getVariable("ldap.password");
        DirContext ctx = LdapUtils.makeConnection(dnServer, dn, dnPassword);
        return ctx != null;
    }

    @Override
    public Validator.Status validate(ProcessingClient client) {
        if (!this.validatePasswordField(client)) {
            return Validator.Status.ERROR;
        }
        DataValidator.Status status = this.validateData(AutomatedInstallData.getInstance());
        Validator.Status validationResult = status == DataValidator.Status.OK ? Validator.Status.OK : Validator.Status.ERROR;
        return validationResult;
    }

    private boolean validatePasswordField(ProcessingClient client) {
        UserInputPanel uip;
        PasswordGroup processingClient;
        PasswordEqualityValidator pev;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        PasswordGroup toTest = (PasswordGroup)client;
        if (toTest.getGroupName() != null && !toTest.getGroupName().isEmpty() && (pev = new PasswordEqualityValidator()).validate(processingClient = (uip = (UserInputPanel)idata.panels.get(idata.curPanelNumber)).getPasswordGroups().get(toTest.getGroupName())) != Validator.Status.OK) {
            this.setWarningMessageId("username.no.match.password");
            this.message = AutomatedInstallData.getInstance().langpack.getString(this.warning);
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessageId() {
        return this.warning;
    }

    @Override
    public String getWarningMessageId() {
        return this.warning;
    }

    private void setWarningMessageId(String warning) {
        this.warning = warning;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }
}

