/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ports.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Debug;
import com.redhat.installer.asconfiguration.ports.utils.PortUtils;
import com.redhat.installer.ports.utils.PortOffset;
import java.util.ArrayList;
import java.util.List;

public class OffsetVariableBridgeAction
implements PanelAction {
    private AutomatedInstallData idata;
    private int domainHttpConsoleNumber;
    private int domainSSLConsoleNumber;
    private final String DOMAIN_HTTP = "domain.management-http";
    private final String DOMAIN_HTTP_PROPERTY = "domain.management-http-1";
    private final String DOMAIN_HTTPS = "domain.management-https";
    private final String DOMAIN_HTTPS_PROPERTY = "domain.management-https-1";
    private String[] domainPortVariables = new String[]{"domain.management-http", "domain.management-http-1", "domain.management-https", "domain.management-https-1"};

    @Override
    public void executeAction(AutomatedInstallData idata, AbstractUIHandler handler) {
        this.idata = idata;
        int portOffset = PortOffset.get();
        try {
            this.checkForInvalidVariables();
        }
        catch (InvalidVariablesException e) {
            Debug.trace(e.getMessage());
        }
        this.setDomainPortValues();
        this.applyDomainPortOffsets(portOffset);
        this.applyStandalonePortOffsets(portOffset);
    }

    private void checkForInvalidVariables() throws InvalidVariablesException {
        ArrayList<String> invalidVariables = new ArrayList<String>();
        invalidVariables.addAll(this.findNonNumberVariables(this.domainPortVariables));
        if (!invalidVariables.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("The following port variables contain invalid values: ");
            for (String variable : invalidVariables) {
                message.append(variable);
                message.append(", ");
            }
            throw new InvalidVariablesException(message.toString());
        }
    }

    private void applyDomainPortOffsets(int portOffset) {
        this.idata.setVariable("domain.port-offset", portOffset + "");
        this.idata.setVariable("domain.port-offset150", portOffset + 150 + "");
        this.idata.setVariable("domain.port-offset250", portOffset + 250 + "");
        this.idata.setVariable("domain.management-http", "${" + this.idata.getVariable("domain.management-http-1") + ":" + (this.domainHttpConsoleNumber + portOffset) + "}");
        this.idata.setVariable("domain.management-https", "${" + this.idata.getVariable("domain.management-https-1") + ":" + (this.domainSSLConsoleNumber + portOffset) + "}");
        this.idata.setVariable("master.domain.port", "${jboss.domain.master.port:" + (9999 + portOffset) + "}");
    }

    private void applyStandalonePortOffsets(int portOffset) {
        this.idata.setVariable("standalone.port-offset", "${jboss.socket.binding.port-offset:" + portOffset + "}");
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    private List<String> findNonNumberVariables(String[] variables) {
        ArrayList<String> nonNumbers = new ArrayList<String>();
        for (String var : variables) {
            String currentVariable = this.idata.getVariable(var);
            if (currentVariable == null) {
                nonNumbers.add(var);
                continue;
            }
            try {
                Integer.parseInt(currentVariable);
            }
            catch (NumberFormatException nfe) {
                nonNumbers.add(var);
            }
        }
        return nonNumbers;
    }

    private void setDomainPortValues() {
        this.domainHttpConsoleNumber = PortUtils.getPort(this.idata.getVariable("domain.management-http"));
        this.domainSSLConsoleNumber = PortUtils.getPort(this.idata.getVariable("domain.management-https"));
    }

    private class InvalidVariablesException
    extends Exception {
        public InvalidVariablesException(String message) {
            super(message);
        }
    }
}

