/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ports.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;

public class PortDefaultReset
implements PanelAction {
    private static AutomatedInstallData idata;
    private static String STANDALONE;
    private static String DOMAIN;

    @Override
    public void executeAction(AutomatedInstallData idata, AbstractUIHandler handler) {
        PortDefaultReset.idata = idata;
        String useCustomPorts = idata.getVariable("portDecision");
        String customDomainPorts = idata.getVariable("configureDomain");
        String customStandalonePorts = idata.getVariable("configureStandalone");
        if (!useCustomPorts.equals("true")) {
            this.resetPorts(STANDALONE);
            this.resetPorts(DOMAIN);
        } else {
            if (customStandalonePorts.equals("false")) {
                this.resetPorts(STANDALONE);
            }
            if (customDomainPorts.equals("false")) {
                this.resetPorts(DOMAIN);
            }
        }
    }

    private void resetPorts(String serverConfig) {
        String[] portVariableNames;
        for (String portVariable : portVariableNames = idata.getVariables().stringPropertyNames().toArray(new String[0])) {
            String value;
            if (!portVariable.startsWith(serverConfig) || portVariable.endsWith("-1") || portVariable.endsWith("-2") || portVariable.endsWith(".orig") || portVariable.endsWith("port-offset") || (value = idata.getVariable(portVariable + ".orig")) == null) continue;
            idata.setVariable(portVariable, value);
        }
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    static {
        STANDALONE = "standalone";
        DOMAIN = "domain";
    }
}

