/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ports.validator;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.redhat.installer.asconfiguration.ports.validator.AddressValidator;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MulticastAddressValidator
extends AddressValidator {
    @Override
    public Validator.Status validate(ProcessingClient client) {
        Validator.Status addressValidation = super.validate(client);
        if (addressValidation == Validator.Status.OK) {
            for (int i = 1; i < client.getNumFields(); ++i) {
                try {
                    InetAddress value = InetAddress.getByName(client.getFieldContents(i));
                    if (value.isMulticastAddress()) continue;
                    return Validator.Status.ERROR;
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
            return Validator.Status.OK;
        }
        return addressValidation;
    }
}

