/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ports.validator;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

public class OffsetPosIntValidator
implements Validator {
    @Override
    public Validator.Status validate(ProcessingClient client) {
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        int numfields = client.getNumFields();
        for (int i = 0; i < numfields; ++i) {
            int offset;
            String value = client.getFieldContents(i);
            if (value == null || value.length() == 0) {
                return failureStatus;
            }
            try {
                offset = Integer.parseInt(value);
            }
            catch (Exception e) {
                return failureStatus;
            }
            if (offset >= 0) continue;
            return failureStatus;
        }
        return Validator.Status.OK;
    }
}

