/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ports.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import java.util.Properties;

public class OffsetValidator
implements Validator {
    private static final int MAXIMUM_VALID_PORT = 65535;

    @Override
    public Validator.Status validate(ProcessingClient client) {
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        Validator.Status validationResult = this.isPortOffsetValidWithHighestPort(client) ? Validator.Status.OK : failureStatus;
        return validationResult;
    }

    private boolean isPortOffsetValidWithHighestPort(ProcessingClient client) {
        int highestUserSpecifiedPort = this.findHighestPortValue();
        int numfields = client.getNumFields();
        boolean isPortOffsetValid = true;
        for (int i = 0; i < numfields; ++i) {
            String portOffset = client.getFieldContents(i);
            try {
                if (Integer.parseInt(portOffset) + highestUserSpecifiedPort <= 65535) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return isPortOffsetValid;
    }

    private int findHighestPortValue() {
        String[] varNames;
        int maxPort = 0;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        Properties variables = idata.getVariables();
        for (String variable : varNames = variables.stringPropertyNames().toArray(new String[0])) {
            if (!variable.startsWith("domain") && !variable.startsWith("standalone")) continue;
            String value = variables.getProperty(variable);
            try {
                if (Integer.parseInt(value) <= maxPort) continue;
                maxPort = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return maxPort;
    }
}

