/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ports.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.asconfiguration.ports.utils.PortUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class PortCollisionValidator
implements DataValidator {
    private static final String ERROR = "port.collision.check.template";
    String message;
    private AutomatedInstallData idata;

    public PortCollisionValidator() {
        this.message = AutomatedInstallData.getInstance().langpack.getString(ERROR);
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        this.idata = idata;
        ArrayList<String> vars = new ArrayList<String>();
        vars.addAll(idata.getVariables().stringPropertyNames());
        String[] portVarNames = vars.toArray(new String[0]);
        return this.findPortCollisions(portVarNames);
    }

    private DataValidator.Status findPortCollisions(String[] portVariableNames) {
        HashSet<Integer> ports = new HashSet<Integer>();
        String serverConfig = this.getConfig();
        List<String> exclusions = this.getExclusions();
        List<String> inclusions = this.getInclusions();
        for (String portVariable : portVariableNames) {
            if (!inclusions.contains(portVariable) && (!portVariable.startsWith(serverConfig + ".") || portVariable.startsWith(serverConfig + ".h.") || portVariable.startsWith(serverConfig + ".f.") || portVariable.startsWith(serverConfig + ".fa.") || portVariable.endsWith("-2") || portVariable.endsWith(".orig"))) continue;
            String value = this.idata.getVariable(portVariable);
            try {
                int portNumber = PortUtils.getPort(value);
                if (ports.add(portNumber) || exclusions.contains(portVariable) || portNumber == 0) continue;
                return DataValidator.Status.ERROR;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DataValidator.Status.OK;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public String getErrorMessageId() {
        return ERROR;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }

    protected abstract String getConfig();

    protected List<String> getExclusions() {
        return new ArrayList<String>();
    }

    protected List<String> getInclusions() {
        return new ArrayList<String>();
    }
}

