/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.ports.validator;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

public class PortWithinRangeValidator
implements Validator {
    @Override
    public Validator.Status validate(ProcessingClient client) {
        int numfields;
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get("warning"))) {
            failureStatus = Validator.Status.WARNING;
        }
        if ((numfields = client.getNumFields()) > 1) {
            for (int i = 1; i < numfields; ++i) {
                String value = client.getFieldContents(i);
                try {
                    if (Integer.parseInt(value) <= 65535 && Integer.parseInt(value) >= 1) continue;
                    return failureStatus;
                }
                catch (NumberFormatException e) {
                    return failureStatus;
                }
            }
        }
        return Validator.Status.OK;
    }
}

