/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.EmbeddedServerCommands;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.PostInstallation;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.File;
import java.util.List;

public class CliScriptHelper {
    private static EmbeddedServerCommands serverCommands;
    private static List<String> cliScripts;
    private static final String RESOLVE_PARAMS = "resolve-params";
    private static final String SCRIPT = "script";
    private static final String HAS_DEPLOY = "has-deploy";
    private static ArgumentParser parser;
    private static AutomatedInstallData idata;
    private static AbstractUIProcessHandler mHandler;
    private static boolean hasDeployCommand;

    public static boolean run(AbstractUIProcessHandler handler, String[] args) throws Exception {
        return CliScriptHelper.initializeStaticVariables(handler, args) && CliScriptHelper.isCliScriptExecutionSuccessful();
    }

    private static boolean initializeStaticVariables(AbstractUIProcessHandler handler, String[] args) throws InterruptedException {
        idata = AutomatedInstallData.getInstance();
        mHandler = handler;
        parser = new ArgumentParser();
        parser.parse(args);
        cliScripts = parser.getListProperty(SCRIPT);
        hasDeployCommand = parser.hasProperty(HAS_DEPLOY) && Boolean.parseBoolean(parser.getStringProperty(HAS_DEPLOY));
        return CliScriptHelper.allScriptsExist() && CliScriptHelper.initializeServerCommands();
    }

    private static boolean allScriptsExist() {
        for (String script : cliScripts) {
            File check = new File(script);
            if (check.exists()) continue;
            ProcessPanelHelper.printToPanel(mHandler, String.format(CliScriptHelper.idata.langpack.getString("CliScriptHelper.notexist"), check.getAbsolutePath()), true);
            return false;
        }
        return true;
    }

    private static boolean initializeServerCommands() throws InterruptedException {
        serverCommands = PostInstallation.initServerCommands(CliScriptHelper.class);
        if (parser.hasProperty(RESOLVE_PARAMS)) {
            String resolution = parser.getStringProperty(RESOLVE_PARAMS);
            serverCommands.setResolveParameterValues(Boolean.parseBoolean(resolution));
        } else {
            serverCommands.setResolveParameterValues(true);
        }
        return true;
    }

    private static boolean isCliScriptExecutionSuccessful() {
        try {
            CliScriptHelper.executeScripts();
        }
        catch (ScriptFailedException sfe) {
            CliScriptHelper.printFailureMessage(sfe.getFailedScriptName());
            boolean bl = false;
            return bl;
        }
        finally {
            serverCommands.closeLogHandlers();
        }
        return true;
    }

    private static boolean executeScripts() throws ScriptFailedException {
        for (String cliScript : cliScripts) {
            File cliScriptFile = new File(cliScript);
            boolean cliScriptResults = serverCommands.runCommandsInList(ServerCommandsHelper.loadCommandsIntoList(cliScript, hasDeployCommand));
            if (!cliScriptResults) {
                throw new ScriptFailedException(cliScriptFile.getAbsolutePath());
            }
            ProcessPanelHelper.printToPanel(mHandler, String.format(CliScriptHelper.idata.langpack.getString("CliScriptHelper.success"), cliScriptFile.getAbsolutePath()), false);
        }
        return true;
    }

    private static void printFailureMessage(String failedScriptName) {
        ProcessPanelHelper.printToPanel(mHandler, String.format(CliScriptHelper.idata.langpack.getString("CliScriptHelper.failure"), failedScriptName), true);
    }

    private static class ScriptFailedException
    extends Exception {
        private String failedScriptName;

        ScriptFailedException(String failedScript) {
            this.failedScriptName = failedScript;
        }

        public String getFailedScriptName() {
            return this.failedScriptName;
        }
    }
}

