/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class DTGovCliModifier {
    private static final String FILE = "file";
    private static final String PASSWORD = "password";

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);
        File dtgovCliFile = new File(parser.getStringProperty(FILE));
        String dtgovPassword = parser.getStringProperty(PASSWORD);
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(dtgovCliFile));
            while ((line = br.readLine()) != null) {
                if (line.endsWith("s-ramp-server")) {
                    line = line + " dtgovworkflows " + dtgovPassword;
                }
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String tempFileName = parser.getStringProperty(FILE) + "TEMP";
        File tempDtgovCliFile = new File(tempFileName);
        idata.setVariable("dtgov.temp.cli.file", tempFileName);
        if (tempDtgovCliFile.exists() && !tempDtgovCliFile.delete()) {
            ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("DTGovCliModifier.tempfile.delete.failed"), tempDtgovCliFile.getAbsolutePath()), true);
        }
        try {
            FileWriter writer = new FileWriter(tempDtgovCliFile, false);
            writer.write(sb.toString());
            ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("DTGovCliModifier.success"), tempDtgovCliFile.getAbsolutePath()), false);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

