/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class PropertiesSetter {
    private static AbstractUIProcessHandler mHandler;

    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        mHandler = handler;
        File propsFile = new File(args[0]);
        if (!propsFile.exists()) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("PropertiesSetter.notexist") + " " + propsFile.getPath(), false);
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("PropertiesSetter.newfile") + " " + propsFile.getPath(), false);
            try {
                if (propsFile.createNewFile()) {
                    ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("directory.creation.failed"), propsFile.toString()), true);
                    return false;
                }
            }
            catch (IOException e) {
                ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("PropertiesSetter.failure") + " " + propsFile.getPath(), true);
                ProcessPanelHelper.printStackTraceToPanel(mHandler, e);
                return false;
            }
        }
        Properties props = new Properties();
        for (int i = 1; i < args.length; ++i) {
            String key = args[i].split("=")[0].trim();
            String string = args[i].split("=", 2)[1].trim();
            props.put(key, string);
        }
        PropertiesConfiguration propConfig = null;
        try {
            propConfig = new PropertiesConfiguration(propsFile);
            for (Object e : props.keySet()) {
                propConfig.setProperty((String)e, props.get(e));
            }
            propConfig.save();
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("PropertiesSetter.success") + " " + propsFile.getPath(), false);
            return true;
        }
        catch (ConfigurationException e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("PropertiesSetter.failure") + " " + propsFile.getPath(), true);
            ProcessPanelHelper.printStackTraceToPanel(mHandler, e);
            return false;
        }
    }
}

