/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.PostInstallation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BxmsSecurityDomain
extends PostInstallation {
    @Override
    protected Class getClassName() {
        return BxmsSecurityDomain.class;
    }

    @Override
    protected boolean performOperation() {
        return BxmsSecurityDomain.installBusinessCentralLdap();
    }

    private static boolean installBusinessCentralLdap() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        ArrayList commandResults = new ArrayList();
        String secdomName = "business-central-ldap";
        String cacheType = "default";
        String authenCode = "LdapExtended";
        String flag = "Required";
        String ldapUrl = idata.getVariable("ldap.url");
        String ldapDn = idata.getVariable("ldap.dn");
        String ldapPlainPwd = idata.getVariable("ldap.password");
        String ldapVaultedPwd = idata.getVariable("ldap.vaulted.password");
        String ldapPwd = ldapVaultedPwd != null ? ldapVaultedPwd : ldapPlainPwd;
        String ldapBrmsUserContext = idata.getVariable("ldap.businesscentral.user.context");
        String ldapBrmsUserFilter = idata.getVariable("ldap.businesscentral.user.filter");
        String ldapBrmsUserRolesFilter = idata.getVariable("ldap.businesscentral.user.roles.filter");
        String ldapBrmsRoleContext = idata.getVariable("ldap.businesscentral.role.context");
        String ldapBrmsRoleFilter = idata.getVariable("ldap.businesscentral.role.filter");
        String ldapBrmsRoleAttribute = idata.getVariable("ldap.businesscentral.role.attributeid");
        String ldapBrmsRoleName = idata.getVariable("ldap.businesscentral.role.nameid");
        String ldapBrmsRoleAttributeIsDn = idata.getVariable("ldap.businesscentral.role.attr.dn");
        HashMap<String, String> ldapBrmsAuthenOptions = new HashMap<String, String>();
        ldapBrmsAuthenOptions.put("java.naming.provider.url", ldapUrl);
        ldapBrmsAuthenOptions.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapBrmsAuthenOptions.put("java.naming.referral", "follow");
        ldapBrmsAuthenOptions.put("java.naming.security.authentication", "simple");
        ldapBrmsAuthenOptions.put("bindDN", ldapDn);
        ldapBrmsAuthenOptions.put("bindCredential", ldapPwd);
        ldapBrmsAuthenOptions.put("baseCtxDN", ldapBrmsUserContext);
        ldapBrmsAuthenOptions.put("baseFilter", ldapBrmsUserFilter);
        ldapBrmsAuthenOptions.put("rolesCtxDN", ldapBrmsRoleContext);
        ldapBrmsAuthenOptions.put("roleFilter", ldapBrmsUserRolesFilter);
        ldapBrmsAuthenOptions.put("roleAttributeID", ldapBrmsRoleAttribute);
        ldapBrmsAuthenOptions.put("roleNameAttributeID", ldapBrmsRoleName);
        ldapBrmsAuthenOptions.put("roleRecursion", "2");
        ldapBrmsAuthenOptions.put("roleAttributeIsDN", ldapBrmsRoleAttributeIsDn);
        ldapBrmsAuthenOptions.put("parseRoleNameFromDN", "false");
        ldapBrmsAuthenOptions.put("searchScope", "SUBTREE_SCOPE");
        ldapBrmsAuthenOptions.put("throwValidateError", "true");
        ArrayList<String> authenCodes = new ArrayList<String>();
        authenCodes.add(authenCode);
        ArrayList<String> authenFlags = new ArrayList<String>();
        authenFlags.add(flag);
        ArrayList<Map<String, String>> authenOptions = new ArrayList<Map<String, String>>();
        authenOptions.add(ldapBrmsAuthenOptions);
        if (!serverCommands.addSecurityDomainAuthenOnly(secdomName, cacheType, authenCodes, authenFlags, authenOptions)) {
            // empty if block
        }
        if (idata.getVariable("new.product.conf") != null && idata.getVariable("new.product.conf").equalsIgnoreCase("bpms")) {
            serverCommands.executeCommand("/subsystem=messaging/hornetq-server=default:write-attribute(name=security-enabled,value=true");
            serverCommands.executeCommand("/subsystem=messaging/hornetq-server=default:write-attribute(name=security-domain,value=" + secdomName);
        }
        return true;
    }
}

