/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.PostInstallation;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.util.HashMap;

public class Datasource
extends PostInstallation {
    @Override
    protected Class getClassName() {
        return Datasource.class;
    }

    @Override
    protected boolean performOperation() {
        return Datasource.installDatasource();
    }

    protected static boolean installDatasource() {
        String prop;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String dsJdbcName = idata.getVariable("jdbc.driver.name");
        String dsName = idata.getVariable("jdbc.datasource.name");
        String dsJndiName = idata.getVariable("jdbc.datasource.jndiname");
        String dsMinPool = idata.getVariable("jdbc.datasource.minpoolsize");
        String dsMaxPool = idata.getVariable("jdbc.datasource.maxpoolsize");
        String dsConnectionUrl = idata.getVariable("jdbc.datasource.connectionurl");
        boolean dsIsXa = idata.getVariable("jdbc.datasource.xa") != null && idata.getVariable("jdbc.datasource.xa").contains("XA");
        HashMap<String, String> dsXaProps = new HashMap<String, String>();
        dsXaProps.put("ServerName", idata.getVariable("jdbc.datasource.xa.servername"));
        dsXaProps.put("DatabaseName", idata.getVariable("jdbc.datasource.xa.databasename"));
        dsXaProps.put("PortNumber", idata.getVariable("jdbc.datasource.xa.portnumber"));
        dsXaProps.put("URL", idata.getVariable("jdbc.datasource.xa.oracleurl"));
        dsXaProps.put("NetworkProtocol", idata.getVariable("jdbc.datasource.xa.sybaseprotocol"));
        dsXaProps.put("SelectMethod", idata.getVariable("jdbc.datasource.xa.microsoftcursor"));
        int counter = 1;
        while ((prop = idata.getVariable("jdbc.datasource.xa.extraprops-" + counter + "-name")) != null) {
            dsXaProps.put(prop, idata.getVariable("jdbc.datasource.xa.extraprops-" + counter + "-value"));
            ++counter;
        }
        String dsUsername = idata.getVariable("jdbc.datasource.username");
        String dsPassword = idata.getVariable("jdbc.datasource.password");
        String dsXaRecoveryUser = idata.getVariable("jdbc.datasource.xa.recoveryuser");
        String dsXaRecoveryPass = idata.getVariable("jdbc.datasource.xa.recoverypass");
        String dsSecurityDomain = idata.getVariable("jdbc.datasource.securitydomain");
        if (dsUsername == null || dsUsername.isEmpty()) {
            idata.setVariable("jdbc.datasource.issecuritydomain", "true");
        }
        boolean isSecurityDomain = Boolean.parseBoolean(idata.getVariable("jdbc.datasource.issecuritydomain"));
        boolean result = true;
        result = dsIsXa ? (isSecurityDomain ? serverCommands.installXaDatasourceSecurityDomain(dsName, dsJndiName, dsJdbcName, dsMinPool, dsMaxPool, dsSecurityDomain, dsXaProps, dsXaRecoveryUser, dsXaRecoveryPass, null) : serverCommands.installXaDatasourceUsernamePwd(dsName, dsJndiName, dsJdbcName, dsMinPool, dsMaxPool, dsUsername, dsPassword, dsXaProps, dsXaRecoveryUser, dsXaRecoveryPass, null)) : (isSecurityDomain ? serverCommands.installDatasourceSecurityDomain(dsName, dsJndiName, dsJdbcName, dsConnectionUrl, dsMinPool, dsMaxPool, dsSecurityDomain, null) : serverCommands.installDatasourceUsernamePwd(dsName, dsJndiName, dsJdbcName, dsConnectionUrl, dsMinPool, dsMaxPool, dsUsername, dsPassword, null));
        if (!result) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.datasource.error"), true);
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.datasource.success"), false);
        }
        return result;
    }
}

