/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.ascontroller.ServerManager;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.PostInstallation;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class Jdbc
extends PostInstallation {
    @Override
    protected Class getClassName() {
        return Jdbc.class;
    }

    @Override
    protected boolean performOperation() {
        return Jdbc.installJdbcDriver();
    }

    static boolean createJdbcFiles(List<String> jarFiles, String moduleDir) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        try {
            File moduleFile = Jdbc.createDirectory(idata.getInstallPath(), moduleDir);
            if (!Boolean.parseBoolean(idata.getVariable("jdbc.driver.preexisting"))) {
                Jdbc.copyJarToModulesDir(jarFiles, moduleFile);
            }
        }
        catch (Throwable e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.jarcopy.error"), true);
            ProcessPanelHelper.printToPanel(mHandler, e.getMessage(), true);
            return false;
        }
        return true;
    }

    public static boolean createJDBCModuleXml(String moduleDirectory, String moduleName, List<String> resources) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String jbossHome = idata.getInstallPath();
        String moduleXmlPath = jbossHome + File.separator + moduleDirectory + File.separator + "module.xml";
        ArrayList<String> resourceNames = new ArrayList<String>();
        ArrayList<String> deps = new ArrayList<String>();
        boolean preexisting = Boolean.parseBoolean(idata.getVariable("jdbc.driver.preexisting"));
        deps.add("javax.api");
        deps.add("javax.transaction.api");
        for (String resource : resources) {
            File resourceFile = new File(resource);
            if (!preexisting) {
                resourceNames.add(resourceFile.getName());
                continue;
            }
            String relativePathToJar = Jdbc.getRelativePath(new File(moduleXmlPath), resourceFile);
            resourceNames.add(relativePathToJar);
        }
        try {
            serverCommands.createModuleXml(jbossHome, moduleDirectory, moduleName, resourceNames, deps);
        }
        catch (ParserConfigurationException e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.xmlcreation.error") + new File(moduleXmlPath).getAbsolutePath(), true);
            return false;
        }
        catch (TransformerException e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.xmlcreation.error") + new File(moduleXmlPath).getAbsolutePath(), true);
            return false;
        }
        catch (IOException e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.xmlcreation.error") + new File(moduleXmlPath).getAbsolutePath(), true);
            return false;
        }
        return true;
    }

    private static boolean installJdbcDriver() {
        String path;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        int counter = 1;
        ArrayList<String> jarFiles = new ArrayList<String>();
        while ((path = idata.getVariable("jdbc.driver.jar-" + counter + "-path")) != null) {
            jarFiles.add(path);
            ++counter;
        }
        idata.setVariable("jdbc.driver.location", new File((String)jarFiles.get(0)).getParent());
        String jdbcName = idata.getVariable("jdbc.driver.name");
        String jdbcModuleName = idata.getVariable("jdbc.driver.module.name");
        String jdbcXaDsName = idata.getVariable("jdbc.driver.xads.name");
        String jdbcDirStruct = idata.getVariable("jdbc.driver.dir.struct");
        if (!Jdbc.createJdbcFiles(jarFiles, jdbcDirStruct)) {
            return false;
        }
        if (!Jdbc.createJDBCModuleXml(jdbcDirStruct, jdbcModuleName, jarFiles)) {
            return false;
        }
        String descriptor = ServerManager.getConfigString();
        try {
            int numOfJars;
            String driverPath = idata.getVariable("jdbc.driver.path");
            String numPreExistingJars = idata.getVariable("jdbc.driver." + descriptor + ".found.count");
            int i = numOfJars = numPreExistingJars != null ? Integer.parseInt(numPreExistingJars) : 0;
            while (numOfJars > 0) {
                String jarPath = idata.getVariable("jdbc.preexisting.driver." + descriptor + "." + i + ".jar");
                if (driverPath.equals(jarPath)) {
                    return true;
                }
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        boolean result = serverCommands.installJdbcDriver(jdbcName, jdbcModuleName, jdbcXaDsName);
        if (!result) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.jdbc.error"), true);
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.jdbc.success"), false);
        }
        return result;
    }

    public static File createDirectory(String basePath, String modulePath) throws Throwable {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        File location = new File(basePath, modulePath);
        if (!location.exists() && !location.mkdirs()) {
            ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("directory.creation.failed"), location.toString()), true);
        }
        return location;
    }

    private static void copyJarToModulesDir(List<String> filenames, File destination) throws Throwable {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        for (String filename : filenames) {
            int l;
            File sourceFile = new File(filename);
            File fileLoc = new File(destination.getPath() + File.separator + sourceFile.getName());
            if (fileLoc.exists()) continue;
            InputStream in = null;
            in = filename.startsWith("http://") || filename.startsWith("ftp://") ? new BufferedInputStream(new URL(filename).openStream()) : new FileInputStream(sourceFile);
            FileOutputStream out = new FileOutputStream(fileLoc);
            byte[] buffer = new byte[1024];
            while ((l = in.read(buffer, 0, 1024)) > 0) {
                ((OutputStream)out).write(buffer, 0, l);
            }
            in.close();
            ((OutputStream)out).close();
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.jarcopy.success"), false);
        }
    }

    static String getRelativePath(File sourceFile, File destFile) {
        int pos;
        String relativePath = "";
        String[] source = sourceFile.getAbsolutePath().split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        String[] dest = destFile.getAbsolutePath().split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        for (pos = 0; pos < source.length && pos < dest.length && source[pos].equals(dest[pos]); ++pos) {
        }
        for (int a = 0; a < source.length - pos - 1; ++a) {
            relativePath = relativePath + ".." + File.separator;
        }
        for (int b = pos; b < dest.length; ++b) {
            relativePath = relativePath + dest[b] + File.separator;
        }
        if ((relativePath = relativePath.substring(0, relativePath.length() - 1)).endsWith("..")) {
            relativePath = relativePath + File.separator + dest[dest.length - 1];
        }
        return relativePath;
    }
}

