/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.PostInstallation;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Jsf
extends PostInstallation {
    @Override
    protected Class getClassName() {
        return Jsf.class;
    }

    @Override
    protected boolean performOperation() {
        return Jsf.installJsf(arguments);
    }

    private static boolean createJsfFile(String jarFile, String moduleDir, String filename) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        try {
            File moduleFile = Jsf.createDirectory(idata.getInstallPath(), moduleDir);
            File jar = new File(jarFile);
            boolean fromUrl = jarFile.startsWith("http://") || jarFile.startsWith("ftp://") || jarFile.startsWith("https://") || jarFile.startsWith("file://");
            try (InputStream in = fromUrl ? new BufferedInputStream(new URL(jarFile).openStream()) : new FileInputStream(jar);){
                Jsf.moveFileToDir(in, filename, moduleFile.getPath());
            }
        }
        catch (Throwable e) {
            ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("postinstall.processpanel.jsfCopy.failure"), jarFile, moduleDir), true);
            ProcessPanelHelper.printStackTraceToPanel(mHandler, e);
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private static boolean createJsfModuleXml(String moduleDirectory, HashMap<String, String> toSet, String templateName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean installJsfImp() {
        String template;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String tmpPath = idata.getVariable("jsfimpl.input.tmp");
        String path = tmpPath == null ? idata.getVariable("jsfimpl.input") : tmpPath;
        String jsfProjectName = idata.getVariable("jsf.project.name");
        String jsfVersion = idata.getVariable("jsf.version");
        String jsfDirStruct = "modules" + File.separator + "com" + File.separator + "sun" + File.separator + "jsf-impl" + File.separator + "" + jsfProjectName + '-' + jsfVersion;
        Boolean isDefault = idata.getVariable("jsfDefault") != null && Boolean.parseBoolean(idata.getVariable("jsfDefault"));
        if (!Jsf.createJsfFile(path, jsfDirStruct, jsfProjectName + "-impl-" + jsfVersion + ".jar")) {
            return false;
        }
        HashMap<String, String> toSet = new HashMap<String, String>();
        toSet.put("\\$\\{jsf-impl-name\\}", jsfProjectName);
        toSet.put("\\$\\{jsf-version\\}", jsfVersion);
        String string = template = jsfProjectName.equals("mojarra") ? "mojarra-impl-module.xml" : "myfaces-impl-module.xml";
        if (!Jsf.createJsfModuleXml(jsfDirStruct, toSet, template)) {
            return false;
        }
        if (isDefault.booleanValue()) {
            boolean result = serverCommands.installJsfDefault(jsfProjectName, jsfVersion);
            if (!result) {
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("postinstall.processpanel.jsf.error"), jsfProjectName + '-' + jsfVersion), true);
            } else {
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("postinstall.processpanel.jsf.success"), jsfProjectName + '-' + jsfVersion), false);
            }
            return result;
        }
        return true;
    }

    private static boolean installJsfApi() {
        String template;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String tmpPath = idata.getVariable("jsfapi.input.tmp");
        String path = tmpPath == null ? idata.getVariable("jsfapi.input") : tmpPath;
        String jsfProjectName = idata.getVariable("jsf.project.name");
        String jsfVersion = idata.getVariable("jsf.version");
        String jsfDirStruct = "modules" + File.separator + "javax" + File.separator + "faces" + File.separator + "api" + File.separator + "" + jsfProjectName + "-" + jsfVersion;
        if (!Jsf.createJsfFile(path, jsfDirStruct, jsfProjectName + "-api-" + jsfVersion + ".jar")) {
            return false;
        }
        HashMap<String, String> toSet = new HashMap<String, String>();
        toSet.put("\\$\\{jsf-impl-name\\}", jsfProjectName);
        toSet.put("\\$\\{jsf-version\\}", jsfVersion);
        String string = template = jsfProjectName.equals("mojarra") ? "mojarra-api-module.xml" : "myfaces-api-module.xml";
        return Jsf.createJsfModuleXml(jsfDirStruct, toSet, template);
    }

    private static String findFirstFilename(File dir, String startWith) {
        String[] files = dir.list((file, s) -> s.startsWith(startWith));
        if (files == null || files.length == 0) {
            return "";
        }
        return files[0];
    }

    private static String extractSubstring(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        String sub = "";
        if (matcher.find()) {
            sub = matcher.group(1);
        }
        return sub;
    }

    private static boolean installJsfInjection() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String jsfProjectName = idata.getVariable("jsf.project.name");
        String jsfVersion = idata.getVariable("jsf.version");
        String jbossHome = idata.getInstallPath();
        String jsfDirStruct = "modules" + File.separator + "org" + File.separator + "jboss" + File.separator + "as" + File.separator + "jsf-injection" + File.separator + jsfProjectName + "-" + jsfVersion;
        String wildflyModules = jbossHome + File.separator + "modules" + File.separator + "system" + File.separator + "layers" + File.separator + "base" + File.separator + "org" + File.separator + "jboss" + File.separator + "as" + File.separator + "jsf-injection" + File.separator + "main" + File.separator;
        File wildflyModulesDir = new File(wildflyModules);
        String weldCore = Jsf.findFirstFilename(wildflyModulesDir, "weld-jsf");
        String wildfly = Jsf.findFirstFilename(wildflyModulesDir, "wildfly-jsf-injection");
        if (weldCore.equals("") || wildfly.equals("")) {
            ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("postinstall.processpanel.jsf.wildfly.modules.not.found"), new Object[0]), true);
            return false;
        }
        String versionWeldCore = Jsf.extractSubstring("^weld-jsf-(.*?)\\.jar$", weldCore);
        String versionJbossAs = Jsf.extractSubstring("^wildfly-jsf-injection-(.*?)\\.jar$", wildfly);
        if (versionJbossAs.equals("") || versionWeldCore.equals("")) {
            ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("postinstall.processpanel.jsf.wildfly.versions.not.found"), new Object[0]), true);
            return false;
        }
        if (!Jsf.createJsfFile(wildflyModulesDir + File.separator + weldCore, jsfDirStruct, weldCore) || !Jsf.createJsfFile(wildflyModulesDir + File.separator + wildfly, jsfDirStruct, wildfly)) {
            return false;
        }
        HashMap<String, String> toSet = new HashMap<String, String>();
        toSet.put("\\$\\{jsf-impl-name\\}", jsfProjectName);
        toSet.put("\\$\\{jsf-version\\}", jsfVersion);
        toSet.put("\\$\\{version.jboss.as\\}", versionJbossAs);
        toSet.put("\\$\\{version.weld.core\\}", versionWeldCore);
        String template = jsfProjectName.equals("mojarra") ? "mojarra-injection-module.xml" : "myfaces-injection-module.xml";
        return Jsf.createJsfModuleXml(jsfDirStruct, toSet, template);
    }

    private static boolean installJsfDigester() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String jsfProjectName = idata.getVariable("jsf.project.name");
        if (jsfProjectName.contains("myfaces")) {
            String commonsDigester;
            Throwable throwable;
            String jsfDirStruct = "modules" + File.separator + "org" + File.separator + "apache" + File.separator + "commons" + File.separator + "digester" + File.separator + "main";
            Properties jsfProps = new Properties();
            try {
                throwable = null;
                try (InputStream propsIn = Jsf.class.getResourceAsStream("/commons-digest.properties");){
                    jsfProps.load(propsIn);
                    commonsDigester = "commons-digester-" + jsfProps.getProperty("version.commons-digester") + ".jar";
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                commonsDigester = "commons-digester.jar";
            }
            try {
                throwable = null;
                try (InputStream in = Jsf.class.getClassLoader().getResourceAsStream("jars/" + commonsDigester);){
                    File moduleFile = Jsf.createDirectory(idata.getInstallPath(), jsfDirStruct);
                    Jsf.moveFileToDir(in, commonsDigester, moduleFile.getPath());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable e) {
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("postinstall.processpanel.jsfCopy.failure"), commonsDigester, jsfDirStruct), true);
                ProcessPanelHelper.printStackTraceToPanel(mHandler, e);
                return false;
            }
            if (!Jsf.createJsfModuleXml(jsfDirStruct, new HashMap<String, String>(), "myfaces-digester-module.xml")) {
                return false;
            }
        }
        return true;
    }

    private static boolean installJsf(String[] args) {
        String flag = "";
        for (String arg : args) {
            if (!arg.startsWith("--stage")) continue;
            flag = arg.split("=")[1];
        }
        switch (flag) {
            case "impl": {
                return Jsf.installJsfImp();
            }
            case "api": {
                return Jsf.installJsfApi();
            }
            case "injection": {
                return Jsf.installJsfInjection();
            }
            case "digest": {
                return Jsf.installJsfDigester();
            }
        }
        return false;
    }

    private static File createDirectory(String basePath, String modulePath) throws Throwable {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        File location = new File(basePath, modulePath);
        if (!location.exists() && !location.mkdirs()) {
            ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("directory.creation.failed"), location.toString()), true);
        }
        return location;
    }

    private static File moveFileToDir(InputStream in, String filename, String destDir) throws Throwable {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        File destination = new File(destDir);
        File fileLoc = new File(destination.getPath() + File.separator + filename);
        if (!fileLoc.exists()) {
            try (FileOutputStream out = new FileOutputStream(fileLoc);){
                int l;
                byte[] buffer = new byte[1024];
                while ((l = in.read(buffer, 0, 1024)) > 0) {
                    ((OutputStream)out).write(buffer, 0, l);
                }
            }
            ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("postinstall.processpanel.jsfCopy.success"), filename, destination.getPath()), false);
        }
        return fileLoc;
    }
}

