/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.PostInstallation;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;

public class Ldap
extends PostInstallation {
    @Override
    protected Class getClassName() {
        return Ldap.class;
    }

    @Override
    protected boolean performOperation() {
        return Ldap.installLdap();
    }

    protected static boolean installLdap() {
        boolean installSsl;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String ldapName = idata.getVariable("ldap.name");
        String ldapUrl = idata.getVariable("ldap.url");
        String ldapDn = idata.getVariable("ldap.dn");
        String ldapPlainPwd = idata.getVariable("ldap.password");
        String ldapVaultedPwd = idata.getVariable("ldap.vaulted.password");
        String ldapPwd = ldapVaultedPwd != null ? ldapVaultedPwd : ldapPlainPwd;
        String ldapRealmName = idata.getVariable("ldap.realmname");
        String ldapBaseDn = idata.getVariable("ldap.basedn");
        String ldapRecursive = idata.getVariable("ldap.recursive");
        boolean ldapFilterType = idata.getVariable("ldap.filtertype") != null && idata.getVariable("ldap.filtertype").equals("advanced");
        String ldapFilter = idata.getVariable("ldap.filter");
        boolean result = serverCommands.installLdap(ldapName, ldapPwd, ldapUrl, ldapDn, ldapRealmName, ldapBaseDn, ldapFilter, ldapRecursive, ldapFilterType);
        boolean bl = installSsl = idata.getVariable("installSsl") != null && Boolean.parseBoolean(idata.getVariable("installSsl"));
        if (installSsl) {
            String keystore = idata.getVariable("ssl.path");
            String keystorePassword = idata.getVariable("ssl.password");
            boolean bl2 = result = result && serverCommands.installSsl(keystore, keystorePassword, ldapRealmName);
        }
        if (!result) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ldap.install.error"), true);
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ldap.install.success"), false);
        }
        return result;
    }
}

