/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.ports.utils.PortUtils;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.PostInstallation;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import com.redhat.installer.ports.utils.PortOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Ports
extends PostInstallation {
    private static final String[] HOST_SERVERS = new String[]{"server-one", "server-two", "server-three"};
    private static final String[] HOST_SLAVE_SERVERS = new String[]{"server-one", "server-two"};
    private static final String[] HOST_MASTER_SERVERS = new String[0];
    private static final String DOMAIN_MASTER_PORT = "master.domain.port";
    private static final String HOST_MANAGEMENT_HTTP_PORT = "host.management-http";

    @Override
    protected Class getClassName() {
        return Ports.class;
    }

    @Override
    protected boolean performOperation() {
        boolean result;
        String variablePrefix = arguments[0];
        boolean offset = AutomatedInstallData.getInstance().getRules().isConditionTrue("port.decisionIsAssist");
        String socketGroupName = Ports.getSocketGroupName(variablePrefix);
        if (offset) {
            switch (variablePrefix) {
                case "host-slave": {
                    result = Ports.configureDomainPortOffsets(HOST_SLAVE_SERVERS) && Ports.writeSlaveSpecificOffsets();
                    break;
                }
                case "host": {
                    result = Ports.configureDomainPortOffsets(HOST_SERVERS) && Ports.writeInterfacePorts();
                    break;
                }
                case "host-master": {
                    result = Ports.configureDomainPortOffsets(HOST_MASTER_SERVERS) && Ports.writeInterfacePorts();
                    break;
                }
                default: {
                    result = Ports.configureStandalonePortOffsets();
                }
            }
            Ports.printResult(result);
        } else {
            result = Ports.configurePorts(socketGroupName, variablePrefix);
        }
        return result;
    }

    private static boolean configurePorts(String socketGroupName, String variablePrefix) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        variablePrefix = variablePrefix.startsWith("host") ? "host" : variablePrefix;
        List<String> portVariables = Ports.getPortVariablesList(variablePrefix);
        for (String port : portVariables) {
            String bindingName;
            boolean result;
            String remainingVarName = port.substring(variablePrefix.length() + 1);
            String portValue = idata.getVariable(port);
            if (remainingVarName.equals("management-http") && serverCommands.isDomain()) {
                result = !serverCommands.isSlave() ? serverCommands.writeHttpManagementPort(portValue) : true;
            } else if (remainingVarName.contains(".multicast-port")) {
                bindingName = remainingVarName.replace(".multicast-port", "");
                result = serverCommands.writeSocketBindingMulticastPort(socketGroupName, bindingName, portValue);
            } else if (remainingVarName.contains(".multicast-address")) {
                bindingName = remainingVarName.replace(".multicast-address", "");
                result = serverCommands.writeSocketBindingMulticastAddress(socketGroupName, bindingName, portValue);
            } else {
                result = serverCommands.writeSocketBindingPort(socketGroupName, remainingVarName, portValue);
            }
            if (!result) {
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("Ports.failed"), portValue), true);
                return false;
            }
            ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("Ports.success"), portValue), false);
        }
        if (serverCommands.isSlave()) {
            String newPort = "" + PortUtils.getPort(idata.getVariable(HOST_MANAGEMENT_HTTP_PORT));
            serverCommands.writeDomainMasterPort(idata.getVariable(DOMAIN_MASTER_PORT), newPort);
        }
        return true;
    }

    private static String getSocketGroupName(String variablePrefix) {
        if (variablePrefix.equals("domain.full")) {
            return "full-sockets";
        }
        if (variablePrefix.equals("domain.h")) {
            return "ha-sockets";
        }
        if (variablePrefix.equals("domain.fa")) {
            return "full-ha-sockets";
        }
        return "standard-sockets";
    }

    private static List<String> getPortVariablesList(String variablePrefix) {
        ArrayList<String> returnList = new ArrayList<String>();
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        Set<String> allVariables = idata.getVariables().stringPropertyNames();
        for (String key : allVariables) {
            if (!key.startsWith(variablePrefix) || key.endsWith("-1") || key.endsWith("-2") || key.endsWith("-a") || key.endsWith("-b")) continue;
            returnList.add(key);
        }
        return returnList;
    }

    private static boolean configureStandalonePortOffsets() {
        String offset = "" + PortOffset.get();
        return serverCommands.writeStandalonePortOffset(offset);
    }

    private static boolean configureDomainPortOffsets(String[] servers) {
        String offset = "" + PortOffset.get();
        return serverCommands.writeDomainPortOffset(offset, servers);
    }

    private static boolean writeInterfacePorts() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        return serverCommands.writeHostInterfacePortOffset("http-interface", idata.getVariable(HOST_MANAGEMENT_HTTP_PORT));
    }

    private static boolean writeSlaveSpecificOffsets() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String masterPort = idata.getVariable(DOMAIN_MASTER_PORT);
        return serverCommands.writeDomainMasterPortOffset(masterPort);
    }

    private static void printResult(boolean result) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        if (result) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("Ports.offset.success"), false);
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("Ports.offset.fail"), true);
        }
    }
}

