/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.PostInstallation;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SecurityDomain
extends PostInstallation {
    @Override
    protected Class getClassName() {
        return SecurityDomain.class;
    }

    @Override
    protected boolean performOperation() {
        return SecurityDomain.installSecurityDomain();
    }

    private static boolean installSecurityDomain() {
        boolean result;
        String value;
        String name;
        String[] option;
        int i;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        ArrayList<String> secDomAuthenCode = new ArrayList<String>();
        ArrayList<String> secDomAuthenFlag = new ArrayList<String>();
        ArrayList<Map<String, String>> secDomAuthenOpts = new ArrayList<Map<String, String>>();
        ArrayList<String> secDomAuthorCode = new ArrayList<String>();
        ArrayList<String> secDomAuthorFlag = new ArrayList<String>();
        ArrayList<Map<String, String>> secDomAuthorOpts = new ArrayList<Map<String, String>>();
        ArrayList<String> secDomMappingCode = new ArrayList<String>();
        ArrayList<String> secDomMappingType = new ArrayList<String>();
        ArrayList<Map<String, String>> secDomMappingOpts = new ArrayList<Map<String, String>>();
        String secDomName = idata.getVariable("securitydomain.name.variable");
        String secDomCache = idata.getVariable("securitydomain.cachetype.variable");
        String onComma = "[,](?=([^\"]*\"[^\"]*\")*[^\"]*$)";
        String onEqual = "[=](?=([^\"]*\"[^\"]*\")*[^\"]*$)";
        if (idata.getRules().isConditionTrue("securitydomain.add.authen")) {
            for (i = 1; i <= Integer.parseInt(idata.getVariable("securitydomain.add.authen-number-dynamic-elements")); ++i) {
                secDomAuthenCode.add(idata.getVariable("securitydomain.add.authen-" + i + "-code"));
                secDomAuthenFlag.add(idata.getVariable("securitydomain.add.authen-" + i + "-flag"));
                HashMap<String, String> secDomAuthenOptsMap = new HashMap<String, String>();
                String authenOpt = idata.getVariable("securitydomain.add.authen-" + i + "-operation");
                if (authenOpt != null) {
                    String[] authenOpts;
                    for (String opt : authenOpts = authenOpt.split(onComma)) {
                        option = opt.split(onEqual);
                        name = option[0];
                        value = option[1].replaceAll("\"", "");
                        secDomAuthenOptsMap.put(name, value);
                    }
                }
                secDomAuthenOpts.add(secDomAuthenOptsMap);
            }
        }
        if (idata.getRules().isConditionTrue("securitydomain.add.author")) {
            for (i = 1; i <= Integer.parseInt(idata.getVariable("securitydomain.add.author-number-dynamic-elements")); ++i) {
                secDomAuthorCode.add(idata.getVariable("securitydomain.add.author-" + i + "-code"));
                secDomAuthorFlag.add(idata.getVariable("securitydomain.add.author-" + i + "-flag"));
                HashMap<String, String> secDomAuthorOptsMap = new HashMap<String, String>(1);
                String authorOpt = idata.getVariable("securitydomain.add.author-" + i + "-operation");
                if (authorOpt != null) {
                    String[] authorOpts;
                    for (String opt : authorOpts = authorOpt.split(onComma)) {
                        option = opt.split(onEqual);
                        name = option[0];
                        value = option[1].replaceAll("\"", "");
                        secDomAuthorOptsMap.put(name, value);
                    }
                }
                secDomAuthorOpts.add(secDomAuthorOptsMap);
            }
        }
        if (idata.getRules().isConditionTrue("securitydomain.add.mapping")) {
            for (i = 1; i <= Integer.parseInt(idata.getVariable("securitydomain.add.mapping-number-dynamic-elements")); ++i) {
                secDomMappingCode.add(idata.getVariable("securitydomain.add.mapping-" + i + "-code"));
                secDomMappingType.add(idata.getVariable("securitydomain.add.mapping-" + i + "-flag"));
                HashMap<String, String> secDomMappingOptsMap = new HashMap<String, String>(1);
                String mappingOpt = idata.getVariable("securitydomain.add.mapping-" + i + "-operation");
                if (mappingOpt != null) {
                    String[] mappingOpts;
                    for (String opt : mappingOpts = mappingOpt.split(onComma)) {
                        option = opt.split(onEqual);
                        name = option[0];
                        value = option[1].replaceAll("\"", "");
                        secDomMappingOptsMap.put(name, value);
                    }
                }
                secDomMappingOpts.add(secDomMappingOptsMap);
            }
        }
        HashMap<String, String> secDomJsseAttrs = null;
        HashMap<String, String> secDomJsseKeystoreAttrs = null;
        HashMap<String, String> secDomJsseKeystoreManagerAttrs = null;
        HashMap<String, String> secDomJsseTruststoreAttrs = null;
        HashMap<String, String> secDomJsseTruststoreManagerAttrs = null;
        Map<String, String> secDomJsseAdditionalProps = null;
        if (Boolean.parseBoolean(idata.getVariable("securityDomainAddJsse"))) {
            boolean installKeystore = Boolean.parseBoolean(idata.getVariable("securityDomainJsseAddKeystore"));
            boolean installKeystoreManager = Boolean.parseBoolean(idata.getVariable("securityDomainJsseAddKeystoreManager"));
            boolean installTruststore = Boolean.parseBoolean(idata.getVariable("securityDomainJsseAddTruststore"));
            boolean installTruststoreManager = Boolean.parseBoolean(idata.getVariable("securityDomainJsseAddTruststoreManager"));
            String ciphersuites = idata.getVariable("securitydomain.jsse.ciphersuites");
            String protocols = idata.getVariable("securitydomain.jsse.protocols");
            String clientalias = idata.getVariable("securitydomain.jsse.client-alias");
            String serveralias = idata.getVariable("securitydomain.jsse.server-alias");
            String authtoken = idata.getVariable("securitydomain.jsse.authtoken");
            if (ciphersuites != null || protocols != null || clientalias != null || serveralias != null || authtoken != null) {
                secDomJsseAttrs = new HashMap<String, String>();
                secDomJsseAttrs.put("cipher-suites", ciphersuites);
                secDomJsseAttrs.put("protocols", protocols);
                secDomJsseAttrs.put("client-alias", clientalias);
                secDomJsseAttrs.put("server-alias", serveralias);
                secDomJsseAttrs.put("service-auth-token", authtoken);
            }
            if (installKeystore) {
                secDomJsseKeystoreAttrs = new HashMap<String, String>();
                secDomJsseKeystoreAttrs.put("password", idata.getVariable("securitydomain.jsse.keystore.password"));
                secDomJsseKeystoreAttrs.put("provider", idata.getVariable("securitydomain.jsse.keystore.provider"));
                secDomJsseKeystoreAttrs.put("provider-argument", idata.getVariable("securitydomain.jsse.keystore.providerargument"));
                secDomJsseKeystoreAttrs.put("type", idata.getVariable("securitydomain.jsse.keystore.type"));
                secDomJsseKeystoreAttrs.put("url", idata.getVariable("securitydomain.jsse.keystore.url"));
            }
            if (installKeystoreManager) {
                secDomJsseKeystoreManagerAttrs = new HashMap<String, String>();
                secDomJsseKeystoreManagerAttrs.put("algorithm", idata.getVariable("securitydomain.jsse.keystoremanager.algorithm"));
                secDomJsseKeystoreManagerAttrs.put("provider", idata.getVariable("securitydomain.jsse.keystoremanager.provider"));
            }
            if (installTruststore) {
                secDomJsseTruststoreAttrs = new HashMap<String, String>();
                secDomJsseTruststoreAttrs.put("password", idata.getVariable("securitydomain.jsse.truststore.password"));
                secDomJsseTruststoreAttrs.put("provider", idata.getVariable("securitydomain.jsse.truststore.provider"));
                secDomJsseTruststoreAttrs.put("provider-argument", idata.getVariable("securitydomain.jsse.truststore.providerargument"));
                secDomJsseTruststoreAttrs.put("type", idata.getVariable("securitydomain.jsse.truststore.type"));
                secDomJsseTruststoreAttrs.put("url", idata.getVariable("securitydomain.jsse.truststore.url"));
            }
            if (installTruststoreManager) {
                secDomJsseTruststoreManagerAttrs = new HashMap<String, String>();
                secDomJsseTruststoreManagerAttrs.put("algorithm", idata.getVariable("securitydomain.jsse.truststoremanager.algorithm"));
                secDomJsseTruststoreManagerAttrs.put("provider", idata.getVariable("securitydomain.jsse.truststoremanager.provider"));
            }
        }
        if (!(result = serverCommands.addSecurityDomain(secDomName, secDomCache, secDomAuthenCode, secDomAuthenFlag, secDomAuthenOpts, secDomAuthorCode, secDomAuthorFlag, secDomAuthorOpts, secDomMappingCode, secDomMappingType, secDomMappingOpts, secDomJsseAttrs, secDomJsseKeystoreAttrs, secDomJsseKeystoreManagerAttrs, secDomJsseTruststoreAttrs, secDomJsseTruststoreManagerAttrs, secDomJsseAdditionalProps))) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.securitydomain.install.error"), true);
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.securitydomain.install.success"), false);
        }
        return result;
    }
}

