/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.PostInstallation;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;

public class Ssl
extends PostInstallation {
    private static final String DOMAIN_HTTPS_KEY = "domain.default.management-https-2";
    private static final String DOMAIN_HTTPS_VARIABLE_KEY = "domain.default.management-https-1";

    static boolean installSsl() {
        String keystorePassword;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String keystore = idata.getVariable("ssl.path");
        boolean result = serverCommands.installSsl(keystore, keystorePassword = idata.getVariable("ssl.password"), "ManagementRealm");
        if (!result) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ssl.error"), true);
            return false;
        }
        ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ssl.success"), false);
        if (arguments.length >= 2 && arguments[1].equals("host-slave")) {
            return true;
        }
        String port = serverCommands.isDomain() ? Ssl.getDomainPortVariable() : null;
        result = serverCommands.addHttps("ManagementRealm", port);
        if (!result) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ssl.https.error"), true);
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ssl.https.success"), false);
        }
        return result;
    }

    private static String getDomainPortVariable() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        return "${" + idata.getVariable(DOMAIN_HTTPS_VARIABLE_KEY) + ":" + idata.getVariable(DOMAIN_HTTPS_KEY) + "}";
    }

    @Override
    protected Class getClassName() {
        return Ssl.class;
    }

    @Override
    protected boolean performOperation() {
        return Ssl.installSsl();
    }
}

