/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.VariableSubstitutor;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.PostInstallation;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.io.File;
import org.jboss.as.security.vault.VaultSession;

public abstract class Vault
extends PostInstallation {
    protected static String resolvedVaultKeystoreUrl;
    protected static String resolvedVaultEncrDir;
    protected static String vaultKeystoreUrl;
    protected static String vaultEncrDir;
    protected static int vaultIterCount;
    protected static String vaultAlias;
    protected static String vaultEncrDirSubbed;
    protected static String vaultKeystoreUrlSubbed;

    protected static void initVaultSession() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String vaultKeystorePwd = idata.getVariable("vault.keystorepwd");
        String vaultSalt = idata.getVariable("vault.salt");
        if (!vaultEncrDir.endsWith(File.separator)) {
            vaultEncrDir = vaultEncrDir + File.separator;
        }
        if (!resolvedVaultEncrDir.endsWith(File.separator)) {
            resolvedVaultEncrDir = resolvedVaultEncrDir + File.separator;
        }
        try {
            serverCommands.createVaultSession(resolvedVaultKeystoreUrl, vaultKeystorePwd, resolvedVaultEncrDir, vaultSalt, vaultIterCount, vaultAlias);
        }
        catch (Throwable e) {
            ProcessPanelHelper.printToPanel(PostInstallation.mHandler, idata.langpack.getString("postinstall.processpanel.vault.failure"), true);
            e.printStackTrace();
        }
    }

    private static void modifyVaultValues() {
        boolean installLdap;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        String configDir = idata.getVariable("jboss.server.config.dir");
        String homeDir = idata.getVariable("jboss.home.dir");
        String defaultKeystoreUrl = vs.substitute(idata.getVariable("vault.keystoreloc.default"));
        String defaultEncrDir = vs.substitute(idata.getVariable("vault.encrdir.default"));
        if (serverCommands.isDomain()) {
            vaultKeystoreUrl = resolvedVaultKeystoreUrl;
            vaultEncrDir = resolvedVaultEncrDir;
        }
        if (defaultKeystoreUrl != null) {
            if (vaultKeystoreUrl.equals(defaultKeystoreUrl)) {
                vaultKeystoreUrlSubbed = "${jboss.home.dir}/vault.keystore";
            } else {
                if (configDir != null) {
                    vaultKeystoreUrl = vaultKeystoreUrl.replace(configDir, "${jboss.server.config.dir}");
                }
                if (homeDir != null) {
                    vaultKeystoreUrl = vaultKeystoreUrl.replace(homeDir, "${jboss.home.dir}");
                }
                vaultKeystoreUrlSubbed = vaultKeystoreUrl;
            }
        }
        if (defaultEncrDir != null) {
            if (vaultEncrDir.equals(defaultEncrDir)) {
                vaultEncrDirSubbed = "${jboss.home.dir}/vault";
            } else {
                if (configDir != null) {
                    vaultEncrDir = vaultEncrDir.replace(configDir, "${jboss.server.config.dir}");
                }
                if (homeDir != null) {
                    vaultEncrDir = vaultEncrDir.replace(homeDir, "${jboss.home.dir}");
                }
                vaultEncrDirSubbed = vaultEncrDir;
            }
        }
        if (installLdap = idata.getRules().isConditionTrue("install.ldap")) {
            Vault.vaultLdapPassword();
        }
    }

    private static void vaultLdapPassword() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String plainLdapPwd = idata.getVariable("ldap.password");
        String ldapName = idata.getVariable("ldap.name");
        VaultSession vault = serverCommands.getVaultSession();
        try {
            if (idata.getVariable("ldap.vaulted.password") == null) {
                idata.setVariable("ldap.vaulted.password", "${" + vault.addSecuredAttribute("ldap", ldapName + ".password", plainLdapPwd.toCharArray()) + "}");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean installVault() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String preExist = idata.getVariable(PostInstallation.xmlDescriptor + ".vault.preexisting");
        boolean vaultPreExisting = preExist != null ? Boolean.parseBoolean(preExist) : false;
        boolean result = true;
        if (!vaultPreExisting) {
            Vault.modifyVaultValues();
            result = !vaultKeystoreUrlSubbed.isEmpty() && !vaultEncrDirSubbed.isEmpty() ? serverCommands.installVault(vaultKeystoreUrlSubbed, vaultEncrDirSubbed) : serverCommands.installVault(vaultKeystoreUrl, vaultEncrDir);
        }
        if (!result) {
            ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("VaultInstaller.install.failure"), new Object[0]), true);
        } else {
            ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("VaultInstaller.install.success"), new Object[0]), false);
        }
        return result;
    }

    static {
        vaultEncrDirSubbed = "";
        vaultKeystoreUrlSubbed = "";
    }
}

