/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.vault.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.jboss.security.Base64Utils;
import org.jboss.security.plugins.PBEUtils;

public class VaultMaskAdjuster
implements PanelAction {
    private String password;

    @Override
    public void executeAction(AutomatedInstallData idata, AbstractUIHandler handler) {
        try {
            String password = this.getPassword();
            String salt = idata.getVariable("vault.salt");
            Integer iterCount = Integer.parseInt(idata.getVariable("vault.itercount"));
            if (password != null) {
                String maskedPassword = this.mockVaultEncode64(password, salt, iterCount);
                while (Base64Utils.fromb64(maskedPassword).length % 8 != 0) {
                    Integer n = iterCount;
                    Integer n2 = iterCount = Integer.valueOf(iterCount + 1);
                    maskedPassword = this.mockVaultEncode64(password, salt, iterCount);
                }
                idata.setVariable("vault.itercount", iterCount.toString());
                idata.setVariable("vault.itercount.default", iterCount.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    private String mockVaultEncode64(String input, String salt, int iterCount) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt.getBytes(), iterCount);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        String maskedPass = PBEUtils.encode64(input.getBytes(), "PBEwithMD5andDES", cipherKey, cipherSpec);
        return maskedPass;
    }

    public String getPassword() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        return idata.getVariable("vault.keystorepwd");
    }
}

