/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.vault.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

public class GenerateRandomPassword {
    private static String validAlphas = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static String validNumbers = "0123456789";
    private static String validSymbols = "!@#$%^&*?";
    private static final String VARIABLE = "variable";

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);
        if (!parser.hasProperty(VARIABLE)) {
            return;
        }
        String varName = parser.getStringProperty(VARIABLE);
        idata.setVariable(varName, GenerateRandomPassword.addRandomChars("", 25));
    }

    public static String addRandomChars(String base, int numRands) {
        String finished = base;
        Random rand = new Random();
        while (numRands > 0) {
            int charChoice = rand.nextInt(3);
            switch (charChoice) {
                case 0: {
                    finished = GenerateRandomPassword.addRandomChar(finished, validAlphas);
                    break;
                }
                case 1: {
                    finished = GenerateRandomPassword.addRandomChar(finished, validNumbers);
                    break;
                }
                case 2: {
                    finished = GenerateRandomPassword.addRandomChar(finished, validSymbols);
                }
            }
            --numRands;
        }
        if (!StringUtils.containsAny(finished, validAlphas)) {
            finished = GenerateRandomPassword.addRandomChar(finished, validAlphas);
        }
        if (!StringUtils.containsAny(finished, validNumbers)) {
            finished = GenerateRandomPassword.addRandomChar(finished, validNumbers);
        }
        if (!StringUtils.containsAny(finished, validSymbols)) {
            finished = GenerateRandomPassword.addRandomChar(finished, validSymbols);
        }
        return finished;
    }

    private static String addRandomChar(String base, String validChars) {
        String finished = base;
        Random rand = new Random();
        int fob = rand.nextInt(2);
        if (fob == 1) {
            int randIndex = rand.nextInt(validChars.length());
            finished = validChars.charAt(randIndex) + finished;
        } else {
            int randIndex = rand.nextInt(validChars.length());
            finished = finished + validChars.charAt(randIndex);
        }
        return finished;
    }

    public String getValidAlphas() {
        return validAlphas;
    }

    public String getValidNumbers() {
        return validNumbers;
    }

    public String getValidSymbols() {
        return validSymbols;
    }
}

