/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.vault.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.VariableSubstitutor;
import com.redhat.installer.asconfiguration.ascontroller.EmbeddedServerCommands;
import com.redhat.installer.asconfiguration.ascontroller.ServerManager;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import java.util.NoSuchElementException;

public class PasswordVaulter {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String PWD_ARGS = "pwd-args";
    private static final String DELIMITER = ",";
    private static final String VAULTED_ATTRIBUTE_PREFIX = "vaulted.";
    private static final String PROPS_VAULTED_ATTRIBUTE_PREFIX = "propsFile.vaulted.";
    private static final String PROPERTY_TEMPLATE = "${%s}";
    private static final String VAULT_PROPERTY_TEMPLATE = "${vault:%s}";

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        ArgumentParser parser = new ArgumentParser();
        parser.setListDelimiter('\uffff');
        parser.parse(args);
        int port = ServerManager.getManagementPort();
        try {
            String username = parser.getStringProperty(USERNAME);
            String password = parser.getStringProperty(PASSWORD);
        }
        catch (NoSuchElementException e) {
            ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("PasswordVaulter.args.failure"), e.getMessage()), true);
            ProcessPanelHelper.printStackTraceToPanel(handler, e);
            return;
        }
        EmbeddedServerCommands serverCommands = new EmbeddedServerCommands();
        try {
            PasswordVaulter.vaultPasswords(idata, serverCommands, parser);
        }
        catch (NoSuchElementException e) {
            ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("PasswordVaulter.args.failure"), e.getMessage()), true);
            ProcessPanelHelper.printStackTraceToPanel(handler, e);
        }
        catch (NullPointerException e) {
            ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("PasswordVaulter.args.triple.failure"), e.getMessage()), true);
            ProcessPanelHelper.printStackTraceToPanel(handler, e);
        }
    }

    private static void vaultPasswords(AutomatedInstallData idata, EmbeddedServerCommands sc, ArgumentParser parser) {
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        for (String param : parser.getListProperty(PWD_ARGS)) {
            String[] pair = param.split(DELIMITER);
            String block = vs.substitute(pair[0]);
            String attribute = vs.substitute(pair[1]);
            String password = vs.substitute(pair[2]);
            String vaultedPassword = PasswordVaulter.vaultPassword(sc, block, attribute, password);
            PasswordVaulter.storeVaultedPassword(idata, attribute, vaultedPassword);
        }
    }

    private static String vaultPassword(EmbeddedServerCommands sc, String block, String attribute, String password) {
        String vaultedPassword = sc.maskPasswordPlain(block, attribute, password);
        return vaultedPassword;
    }

    private static void storeVaultedPassword(AutomatedInstallData idata, String attribute, String vaultedPassword) {
        String vaultedAttribute = VAULTED_ATTRIBUTE_PREFIX + attribute;
        String propsFileVaultedAttribute = PROPS_VAULTED_ATTRIBUTE_PREFIX + attribute;
        String propertyPassword = String.format(PROPERTY_TEMPLATE, vaultedPassword);
        String vaultedPropertyPassword = String.format(VAULT_PROPERTY_TEMPLATE, vaultedPassword);
        idata.setVariable(vaultedAttribute, propertyPassword);
        idata.setVariable(propsFileVaultedAttribute, vaultedPropertyPassword);
        System.setProperty(vaultedAttribute, propertyPassword);
        System.setProperty(propsFileVaultedAttribute, vaultedPropertyPassword);
    }
}

