/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.vault.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.jboss.security.Base64Utils;
import org.jboss.security.plugins.PBEUtils;

public class VaultMaskValidator
implements DataValidator {
    String errorLangpackId;
    String formattedMessage;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData idata) {
        try {
            String salt = idata.getVariable("vault.salt");
            int iterCount = Integer.parseInt(idata.getVariable("vault.itercount"));
            String password = this.getPassword();
            if (password == null) {
                this.setErrorLangpackId("VaultMaskValidator.missing.password");
                this.setFormattedMessage(idata.langpack.getString(this.getErrorMessageId()));
                return DataValidator.Status.ERROR;
            }
            String maskedPassword = this.mockVaultEncode64(password, salt, iterCount);
            if (Base64Utils.fromb64(maskedPassword).length % 8 != 0) {
                this.setErrorLangpackId("VaultMaskValidator.invalid.password");
                this.setFormattedMessage(String.format(idata.langpack.getString(this.getErrorMessageId()), new Object[0]));
                return DataValidator.Status.ERROR;
            }
        }
        catch (Exception e) {
            this.setErrorLangpackId("VaultMaskValidator.exception.occurred");
            this.setFormattedMessage(String.format(idata.langpack.getString(this.getErrorMessageId()), e.getLocalizedMessage()));
            e.printStackTrace();
        }
        return DataValidator.Status.OK;
    }

    private String mockVaultEncode64(String input, String salt, int iterCount) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt.getBytes(), iterCount);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        String maskedPass = PBEUtils.encode64(input.getBytes(), "PBEwithMD5andDES", cipherKey, cipherSpec);
        return maskedPass;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorLangpackId;
    }

    @Override
    public String getWarningMessageId() {
        return this.errorLangpackId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public void setErrorLangpackId(String errorLangpackId) {
        this.errorLangpackId = errorLangpackId;
    }

    public void setFormattedMessage(String formattedMessage) {
        this.formattedMessage = formattedMessage;
    }

    public String getPassword() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        return idata.getVariable("vault.keystorepwd");
    }
}

