/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.asconfiguration.vault.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import com.redhat.installer.asconfiguration.keystore.validator.KeystoreValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.SecretKey;

public class VaultValidator
extends KeystoreValidator {
    private static final int DOES_NOT_EXIST = 2;
    private static final String NEW_VAULT = "new.postinstall.vault";
    private boolean keyExists = false;

    @Override
    protected DataValidator.Status performAdditionalChecksOnSuccess(String algorithm) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String keystorePath = idata.getVariable("vault.keystoreloc");
        char[] keystorePassword = idata.getVariable("vault.keystorepwd").toCharArray();
        String keyAlias = idata.getVariable("vault.alias");
        this.keyExists = false;
        try {
            KeyStore keystore = KeyStore.getInstance(algorithm);
            if (KeystoreValidator.isValidAccessibleUrl(keystorePath)) {
                keystore.load(new URI(keystorePath).toURL().openStream(), keystorePassword);
            } else if (KeystoreValidator.isValidReadableFile(keystorePath)) {
                FileInputStream inStream = new FileInputStream(keystorePath);
                keystore.load(inStream, keystorePassword);
                inStream.close();
            }
            if (keystore.containsAlias(keyAlias)) {
                Key vaultKey = keystore.getKey(keyAlias, keystorePassword);
                this.keyExists = true;
                if (this.requiresSecretKey()) {
                    if (vaultKey instanceof SecretKey) {
                        this.setVariable();
                        return DataValidator.Status.OK;
                    }
                    this.setError("vault.key.algorithm.not.supported");
                    this.setMessage(String.format(idata.langpack.getString(this.getErrorMessageId()), keyAlias));
                    return DataValidator.Status.ERROR;
                }
            } else if (!algorithm.toLowerCase().equals("jceks")) {
                this.setError("vault.key.creation.keystore.type.error");
                this.setMessage(String.format(idata.langpack.getString(this.getErrorMessageId()), new Object[0]));
                return DataValidator.Status.ERROR;
            }
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.setVariable();
        return DataValidator.Status.OK;
    }

    @Override
    protected boolean hasAdditionalChecksOnSuccess() {
        return true;
    }

    @Override
    public String getKeystorePath() {
        return AutomatedInstallData.getInstance().getVariable("vault.keystoreloc");
    }

    @Override
    public String getEncryptedDirPath() {
        return AutomatedInstallData.getInstance().getVariable("vault.encrdir");
    }

    @Override
    public String[] getSupportedFormats() {
        return AutomatedInstallData.getInstance().getVariable("vault.allowed.keystore.types").split(",");
    }

    @Override
    public char[] getKeystorePassword() {
        return AutomatedInstallData.getInstance().getVariable("vault.keystorepwd").toCharArray();
    }

    @Override
    public boolean hasAdditionalChecksOnFail() {
        return true;
    }

    @Override
    public void setVariable() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        if (this.keyExists) {
            idata.setVariable(NEW_VAULT, "false");
        } else {
            idata.setVariable(NEW_VAULT, "true");
        }
    }

    @Override
    public DataValidator.Status getFailureStatus() {
        return null;
    }

    @Override
    public DataValidator.Status performAdditionalChecksOnFail(int result) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        if (2 != result) {
            return DataValidator.Status.ERROR;
        }
        idata.setVariable(NEW_VAULT, "true");
        String path = this.getKeystorePath();
        if (path.equals(this.getEncryptedDirPath())) {
            this.setError("vault.path.same.as.encrypted");
            this.setMessage(idata.langpack.getString(this.error));
            return DataValidator.Status.ERROR;
        }
        File file = new File(path);
        if (path.isEmpty()) {
            this.setError("vault.path.is.directory");
            this.setMessage(idata.langpack.getString(this.error));
            return DataValidator.Status.ERROR;
        }
        if (file.isDirectory()) {
            this.setError("vault.path.is.directory");
            this.setMessage(idata.langpack.getString(this.error));
            return DataValidator.Status.ERROR;
        }
        if (file.exists()) {
            this.setError("vault.path.existing");
            this.setMessage(idata.langpack.getString(this.error));
            return DataValidator.Status.ERROR;
        }
        if (path.equals(vs.substitute(idata.getVariable("vault.keystoreloc.default")))) {
            return DataValidator.Status.OK;
        }
        File absoluteParent = IoHelper.existingParent(file);
        File immediateParent = file.getParentFile();
        if (absoluteParent == null || !absoluteParent.canWrite()) {
            this.setError("vault.path.no.write.permission");
            this.setMessage(idata.langpack.getString(this.error));
            return DataValidator.Status.ERROR;
        }
        if (immediateParent == null || !immediateParent.exists()) {
            this.setError("vault.path.parent.notexisting.warning");
            this.setMessage(idata.langpack.getString(this.error));
            return DataValidator.Status.WARNING;
        }
        return DataValidator.Status.OK;
    }

    private boolean requiresSecretKey() {
        return AutomatedInstallData.getInstance().getVariable("vault.requires.secret.key").toLowerCase().equals("true");
    }

    private String getProductName() {
        return AutomatedInstallData.getInstance().getVariable("product.name");
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return this.error;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    protected boolean getCondition() {
        return true;
    }

    @Override
    public String getFormattedMessage() {
        return this.message;
    }
}

