/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.installer.dynamic.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.ParameteredDataValidator;
import java.util.HashSet;
import java.util.Map;

public class NoDuplicatesValidator
extends ParameteredDataValidator {
    public static final String VAR_START = "variable_start";
    public static final String VAR_END = "variable_end";
    public static final String ERROR = "error";
    String errorMessage;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        Map<String, String> params = this.getParameters();
        String componentVariable = adata.getVariable(params.get(VAR_START) + "-number-dynamic-elements");
        String isEnabled = adata.getVariable(params.get(VAR_START));
        Boolean skip = isEnabled == null ? false : isEnabled.equals("No");
        if (componentVariable == null || skip.booleanValue()) {
            return DataValidator.Status.SKIP;
        }
        int numberComponents = Integer.parseInt(componentVariable);
        HashSet<String> entries = new HashSet<String>();
        String errorKey = params.get(ERROR);
        this.errorMessage = adata.langpack.getString(errorKey);
        for (int i = 1; i <= numberComponents; ++i) {
            entries.add(adata.getVariable(String.format("%s-%d-%s", params.get(VAR_START), i, params.get(VAR_END))));
        }
        if (entries.size() != numberComponents) {
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return this.errorMessage;
    }
}

